/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.RegistrySimple;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;

public class GuiSoundSelect
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private final SongPlayData.SongEntry songEntry;
    private Field sndRegistry;
    private CompositeScrolled area;
    private Text selectionLabel;

    protected GuiSoundSelect(GuiContainerBase parent, SongPlayData.SongEntry entry) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.songEntry = entry;
        try {
            this.sndRegistry = ReflectionHelper.findField(SoundHandler.class, (String[])new String[]{"sndRegistry", "field_147697_e"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void initElements() {
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSoundSelect.this.parent);
                GuiSoundSelect.this.parent.refreshGui();
            }
        };
        this.addGuiElement(button);
        this.selectionLabel = new Text(8, 30, 240, this.songEntry.name(), this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                String old = this.getText();
                super.handleKeyInput(keyCode, ch);
                String text = this.getText();
                if (!text.equals(old)) {
                    GuiSoundSelect.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.selectionLabel);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        UnmodifiableIterator itr;
        this.area.clearElements();
        try {
            itr = Iterators.filter(((RegistrySimple)this.sndRegistry.get(Minecraft.func_71410_x().func_147118_V())).func_148742_b().iterator(), (Predicate)new Predicate(){

                public boolean apply(Object input) {
                    return input.toString().contains(GuiSoundSelect.this.selectionLabel.getText());
                }
            });
        }
        catch (Exception e) {
            return;
        }
        int totalHeight = 8;
        while (itr.hasNext()) {
            final String name = itr.next().toString();
            Button button = new Button(8, totalHeight, 232, 12, name){

                @Override
                protected void onPressed() {
                    GuiSoundSelect.this.songEntry.setName(name);
                    GuiSoundSelect.this.selectionLabel.setText(name);
                    GuiSoundSelect.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }
}

