/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gates.types;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.DualBoundingBox;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.gates.IGateType;
import net.shadowmage.ancientwarfare.structure.gates.types.GateDouble;
import net.shadowmage.ancientwarfare.structure.gates.types.GateRotatingBridge;
import net.shadowmage.ancientwarfare.structure.gates.types.GateSingle;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;

public class Gate
implements IGateType {
    private static final Gate[] gateTypes = new Gate[16];
    private static final Gate basicWood = new Gate(0, "Wood1.png").setName("gateBasicWood").setIcon("gateWoodBasic");
    private static final Gate basicIron = new Gate(1, "Iron1.png").setName("gateBasicIron").setIcon("gateIronBasic").setModel(1);
    private static final Gate singleWood = new GateSingle(4, "Wood1.png").setName("gateSingleWood").setIcon("gateWoodSingle");
    private static final Gate singleIron = new GateSingle(5, "Iron1.png").setName("gateSingleIron").setIcon("gateIronSingle").setModel(1);
    private static final Gate doubleWood = new GateDouble(8, "Wood1.png").setName("gateDoubleWood").setIcon("gateWoodDouble");
    private static final Gate doubleIron = new GateDouble(9, "Iron1.png").setName("gateDoubleIron").setIcon("gateIronDouble").setModel(1);
    private static final Gate rotatingBridge = new GateRotatingBridge(12, "BridgeWood1.png");
    public static final HashMap<String, Integer> gateIDByName = new HashMap();
    protected final int globalID;
    protected String displayName = "";
    protected String tooltip = "";
    protected String iconTexture = "";
    protected int maxHealth = 40;
    protected int modelType = 0;
    protected boolean canSoldierInteract = true;
    protected float moveSpeed = 0.025f;
    protected final ItemStack displayStack;
    protected final ResourceLocation textureLocation;
    protected IIcon itemIcon;

    public Gate(int id, String textureLocation) {
        this.globalID = id;
        this.tooltip = "item.gate." + id + ".tooltip";
        if (id >= 0 && id < gateTypes.length && gateTypes[id] == null) {
            Gate.gateTypes[id] = this;
        }
        this.displayStack = new ItemStack((Item)AWStructuresItemLoader.gateSpawner, 1, id);
        this.textureLocation = new ResourceLocation("ancientwarfare:textures/model/structure/gate/gate" + textureLocation);
    }

    protected final Gate setName(String name) {
        this.displayName = name;
        return this;
    }

    protected final Gate setIcon(String icon) {
        this.iconTexture = icon;
        return this;
    }

    protected final Gate setModel(int type) {
        this.modelType = type;
        return this;
    }

    @Override
    public void registerIcons(IIconRegister reg) {
        this.itemIcon = reg.func_94245_a("ancientwarfare:structure/gates/" + this.iconTexture);
    }

    @Override
    public IIcon getIconTexture() {
        return this.itemIcon;
    }

    @Override
    public int getGlobalID() {
        return this.globalID;
    }

    @Override
    public int getModelType() {
        return this.modelType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public ItemStack getConstructingItem() {
        return new ItemStack((Item)AWStructuresItemLoader.gateSpawner, 1, this.globalID);
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    @Override
    public boolean canActivate(EntityGate gate, boolean open) {
        return true;
    }

    @Override
    public boolean canSoldierActivate() {
        return this.canSoldierInteract;
    }

    public static String getGateNameFor(EntityGate gate) {
        int id = gate.getGateType().getGlobalID();
        return Gate.getGateNameFor(id);
    }

    public static String getGateNameFor(int id) {
        for (String key : gateIDByName.keySet()) {
            int gateID = gateIDByName.get(key);
            if (gateID != id) continue;
            return key;
        }
        return "gate.verticalWooden";
    }

    public static Gate getGateByName(String name) {
        if (gateIDByName.containsKey(name)) {
            return Gate.getGateByID(gateIDByName.get(name));
        }
        return basicWood;
    }

    public static Gate getGateByID(int id) {
        if (id >= 0 && id < gateTypes.length) {
            return gateTypes[id];
        }
        return basicWood;
    }

    @Override
    public void onUpdate(EntityGate ent) {
    }

    @Override
    public void setCollisionBoundingBox(EntityGate gate) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return;
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        if (!(gate.field_70121_D instanceof DualBoundingBox)) {
            try {
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)gate, (Object)((Object)new DualBoundingBox(min, max)), (String[])new String[]{"boundingBox", "field_70121_D"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gate.edgePosition > 0.0f) {
            gate.field_70121_D.func_72324_b((double)min.x, (double)max.y + 0.5, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
        } else {
            gate.field_70121_D.func_72324_b((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
        }
    }

    @Override
    public boolean arePointsValidPair(BlockPosition pos1, BlockPosition pos2) {
        return pos1.x == pos2.x || pos1.z == pos2.z;
    }

    @Override
    public void setInitialBounds(EntityGate gate, BlockPosition pos1, BlockPosition pos2) {
        BlockPosition min = BlockTools.getMin(pos1, pos2);
        BlockPosition max = BlockTools.getMax(pos1, pos2);
        boolean wideOnXAxis = min.x != max.x;
        float width = wideOnXAxis ? (float)(max.x - min.x + 1) : (float)(max.z - min.z + 1);
        float xOffset = wideOnXAxis ? width * 0.5f : 0.5f;
        float zOffset = wideOnXAxis ? 0.5f : width * 0.5f;
        gate.pos1 = min;
        gate.pos2 = max;
        gate.edgeMax = max.y - min.y + 1;
        gate.func_70107_b((float)min.x + xOffset, min.y, (float)min.z + zOffset);
    }

    @Override
    public void onGateStartOpen(EntityGate gate) {
        if (gate.field_70170_p.field_72995_K) {
            return;
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        this.removeBetween(gate.field_70170_p, min, max);
    }

    @Override
    public void onGateFinishOpen(EntityGate gate) {
    }

    @Override
    public void onGateStartClose(EntityGate gate) {
    }

    @Override
    public void onGateFinishClose(EntityGate gate) {
        if (gate.field_70170_p.field_72995_K) {
            return;
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        this.placeBetween(gate, min, max);
    }

    public final void removeBetween(World world, BlockPosition min, BlockPosition max) {
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    Block id = world.func_147439_a(x, y, z);
                    if (id != AWBlocks.gateProxy) continue;
                    world.func_147468_f(x, y, z);
                }
            }
        }
    }

    public final void placeBetween(EntityGate gate, BlockPosition min, BlockPosition max) {
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileEntity te;
                    Block block = gate.field_70170_p.func_147439_a(x, y, z);
                    if (!block.isAir((IBlockAccess)gate.field_70170_p, x, y, z)) {
                        block.func_149697_b(gate.field_70170_p, x, y, z, gate.field_70170_p.func_72805_g(x, y, z), 0);
                    }
                    if (!gate.field_70170_p.func_147449_b(x, y, z, AWBlocks.gateProxy) || !((te = gate.field_70170_p.func_147438_o(x, y, z)) instanceof TEGateProxy)) continue;
                    ((TEGateProxy)te).setOwner(gate);
                }
            }
        }
    }

    public static EntityGate constructGate(World world, BlockPosition pos1, BlockPosition pos2, Gate type, byte facing) {
        BlockPosition min = BlockTools.getMin(pos1, pos2);
        BlockPosition max = BlockTools.getMax(pos1, pos2);
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    if (world.func_147437_c(x, y, z)) continue;
                    AWLog.logDebug("could not create gate for non-air block at: " + x + "," + y + "," + z + " block: " + world.func_147439_a(x, y, z));
                    return null;
                }
            }
        }
        if (pos1.x == pos2.x) {
            if (facing == 0 || facing == 2) {
                facing = (byte)(facing + 1);
                facing = (byte)(facing % 4);
            }
        } else if (pos1.z == pos2.z && (facing == 1 || facing == 3)) {
            facing = (byte)(facing + 1);
            facing = (byte)(facing % 4);
        }
        EntityGate ent = new EntityGate(world);
        ent.setGateType(type);
        ent.gateOrientation = facing;
        type.setInitialBounds(ent, pos1, pos2);
        type.onGateFinishClose(ent);
        return ent;
    }

    public static ItemStack getItemToConstruct(int type) {
        return Gate.getGateByID(type).getConstructingItem();
    }

    public static ItemStack getItemToConstruct(String typeName) {
        return Gate.getGateByName(typeName).getConstructingItem();
    }

    public static void registerIconsForGates(IIconRegister reg) {
        for (Gate t : gateTypes) {
            if (t == null) continue;
            t.registerIcons(reg);
        }
    }

    static {
        gateIDByName.put("gate.verticalWooden", 0);
        gateIDByName.put("gate.verticalIron", 1);
        gateIDByName.put("gate.singleWood", 4);
        gateIDByName.put("gate.singleIron", 5);
        gateIDByName.put("gate.doubleWood", 8);
        gateIDByName.put("gate.doubleIron", 9);
        gateIDByName.put("gate.drawbridge", 12);
    }
}

