/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.api;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTTools {
    public static NBTTagCompound writeItemStack(ItemStack stack, NBTTagCompound tag) {
        tag.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        tag.func_74768_a("damage", stack.func_77960_j());
        tag.func_74768_a("quantity", stack.field_77994_a);
        if (stack.field_77990_d != null) {
            tag.func_74782_a("stackTag", stack.field_77990_d.func_74737_b());
        }
        return tag;
    }

    public static ItemStack readItemStack(NBTTagCompound tag) {
        if (tag.func_74764_b("item") && tag.func_74764_b("damage") && tag.func_74764_b("quantity")) {
            Item item = (Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("item"));
            int damage = tag.func_74762_e("damage");
            int quantity = tag.func_74762_e("quantity");
            NBTTagCompound stackTag = null;
            if (tag.func_74764_b("stackTag")) {
                stackTag = tag.func_74775_l("stackTag");
            }
            if (item != null) {
                ItemStack stack = new ItemStack(item, quantity, damage);
                stack.field_77990_d = stackTag;
                return stack;
            }
        }
        return null;
    }

    public static int safeParseInt(String num) {
        try {
            return Integer.parseInt(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double safeParseDouble(String num) {
        try {
            return Double.parseDouble(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static long safeParseLong(String num) {
        try {
            return Long.parseLong(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static byte safeParseByte(String num) {
        try {
            return Byte.parseByte(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short safeParseShort(String num) {
        try {
            return Short.parseShort(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static float safeParseFloat(String val) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static byte[] parseByteArray(String csv) {
        String[] splits = csv.split(",");
        byte[] array = new byte[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Byte.parseByte(splits[i].trim());
        }
        return array;
    }

    public static int[] parseIntArray(String csv) {
        String[] splits = csv.split(",");
        int[] array = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Integer.parseInt(splits[i].trim());
        }
        return array;
    }

    public static String getCSVStringForArray(float[] values) {
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static String getCSVStringForArray(byte[] values) {
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static String getCSVStringForArray(int[] values) {
        if (values == null) {
            return "";
        }
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static int[] safeParseIntArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return NBTTools.parseIntArray(splits[1]);
        }
        return new int[0];
    }

    public static NBTTagCompound readNBTFrom(List<String> lines) {
        return NBTTools.parseNBTFromLines(lines);
    }

    @Deprecated
    public static void writeNBTToLines(NBTTagCompound tag, List<String> lines) {
        List<String> lines1 = NBTTools.getLinesFor(tag);
        lines.addAll(lines1);
    }

    public static List<String> getLinesFor(NBTTagCompound tag) {
        return NBTTools.getLinesForNBT(tag);
    }

    public static void writeNBTTagCompound(NBTTagCompound tag, DataOutputStream data) throws IOException {
        if (tag == null) {
            data.writeShort(-1);
        } else {
            byte[] var2 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            data.writeShort((short)var2.length);
            data.write(var2);
        }
    }

    public static void writeTagToStream(NBTTagCompound tag, ByteArrayDataOutput data) {
        if (tag == null) {
            data.writeShort(-1);
        } else {
            try {
                byte[] var2 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
                data.writeShort((int)((short)var2.length));
                data.write(var2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static NBTTagCompound readNBTTagCompound(DataInputStream data) throws IOException {
        short var1 = data.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        data.readFully(var2);
        return CompressedStreamTools.func_74796_a((InputStream)data);
    }

    public static NBTTagCompound readTagFromStream(ByteArrayDataInput data) {
        short var1 = data.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        data.readFully(var2);
        try {
            return CompressedStreamTools.func_152457_a((byte[])var2, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new NBTTagCompound();
        }
    }

    private static NBTTagCompound parseNBTFromLines(List<String> lines) {
        TagCompound tag = NBTTools.parseTagFromLines(lines);
        return (NBTTagCompound)tag.getNBT();
    }

    private static List<String> getLinesForNBT(NBTTagCompound nbttag) {
        ArrayList<String> lines = new ArrayList<String>();
        TagCompound tag = new TagCompound();
        tag.createFromNBT((NBTBase)nbttag);
        tag.getTagLines("", lines);
        return lines;
    }

    private static TagCompound parseTagFromLines(List<String> lines) {
        TagCompound tag = new TagCompound();
        tag.parseFromLines(lines);
        return tag;
    }

    private static TagBase getTag(int type) {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return new TagByte();
            }
            case 2: {
                return new TagShort();
            }
            case 3: {
                return new TagInt();
            }
            case 4: {
                return new TagLong();
            }
            case 5: {
                return new TagFloat();
            }
            case 6: {
                return new TagDouble();
            }
            case 7: {
                return new TagByteArray();
            }
            case 8: {
                return new TagString();
            }
            case 9: {
                return new TagList();
            }
            case 10: {
                return new TagCompound();
            }
            case 11: {
                return new TagIntArray();
            }
        }
        return null;
    }

    private static List<String> parseNextTag(List<String> lines) {
        int open = 0;
        int close = 0;
        ArrayList<String> linesOut = new ArrayList<String>();
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next();
            if (line.startsWith("TAG=")) {
                ++open;
            }
            if (line.startsWith("}") || line.endsWith("}")) {
                ++close;
            }
            linesOut.add(line);
            it.remove();
            if (open <= 0 || open != close) continue;
            break;
        }
        return linesOut;
    }

    private static class TagCompound
    extends TagBase {
        HashMap<String, TagBase> tags = new HashMap();

        private TagCompound() {
        }

        @Override
        int getType() {
            return 10;
        }

        @Override
        NBTBase getNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            for (String key : this.tags.keySet()) {
                tag.func_74782_a(key, this.tags.get(key).getNBT());
            }
            return tag;
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=10=" + tagName + "{");
            for (String key : this.tags.keySet()) {
                this.tags.get(key).getTagLines(key, lines);
            }
            lines.add("}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            lines.remove(0);
            lines.remove(lines.size() - 1);
            while (!lines.isEmpty()) {
                List tagLines = NBTTools.parseNextTag(lines);
                String line = (String)tagLines.get(0);
                String[] splits = line.split("=", -1);
                int tagType = NBTTools.safeParseInt(splits[1]);
                String tagName = splits[2].split("\\{")[0];
                TagBase tag = NBTTools.getTag(tagType);
                tag.parseFromLines(tagLines);
                this.tags.put(tagName, tag);
            }
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                NBTBase baseTag = tag.func_74781_a(key);
                TagBase newTag = NBTTools.getTag(baseTag.func_74732_a());
                newTag.createFromNBT(baseTag);
                this.tags.put(key, newTag);
            }
        }
    }

    private static class TagList
    extends TagBase {
        List<TagBase> tags = new ArrayList<TagBase>();

        private TagList() {
        }

        @Override
        int getType() {
            return 9;
        }

        @Override
        NBTBase getNBT() {
            NBTTagList list = new NBTTagList();
            for (TagBase tag : this.tags) {
                list.func_74742_a(tag.getNBT());
            }
            return list;
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=9=" + tagName + "{");
            for (TagBase tag : this.tags) {
                tag.getTagLines("", lines);
            }
            lines.add("}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            lines.remove(0);
            lines.remove(lines.size() - 1);
            while (!lines.isEmpty()) {
                List tagLines = NBTTools.parseNextTag(lines);
                String line = (String)tagLines.get(0);
                int tagType = NBTTools.safeParseInt(line.split("=", -1)[1]);
                TagBase tag = NBTTools.getTag(tagType);
                tag.parseFromLines(tagLines);
                this.tags.add(tag);
            }
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            NBTTagList tag = (NBTTagList)nbt.func_74737_b();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTBase innerTag = tag.func_74744_a(0);
                byte type = innerTag.func_74732_a();
                TagBase realTag = NBTTools.getTag(type);
                realTag.createFromNBT(innerTag);
                this.tags.add(realTag);
            }
        }
    }

    private static class TagIntArray
    extends TagBase {
        int[] data;

        private TagIntArray() {
        }

        @Override
        int getType() {
            return 11;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagIntArray(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=11=" + tagName + "{" + NBTTools.getCSVStringForArray(this.data) + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.parseIntArray(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagIntArray)nbt).func_150302_c();
        }
    }

    private static class TagLong
    extends TagBase {
        long data;

        private TagLong() {
        }

        @Override
        int getType() {
            return 4;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagLong(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=4=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseLong(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagLong)nbt).func_150291_c();
        }
    }

    private static class TagByteArray
    extends TagBase {
        byte[] data;

        private TagByteArray() {
        }

        @Override
        int getType() {
            return 7;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagByteArray(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=7=" + tagName + "{" + NBTTools.getCSVStringForArray(this.data) + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.parseByteArray(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagByteArray)nbt).func_150292_c();
        }
    }

    private static class TagString
    extends TagBase {
        String data;

        private TagString() {
        }

        @Override
        int getType() {
            return 8;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagString(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=8=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            this.data = data = data.split("\\}", -1)[0];
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagString)nbt).func_150285_a_();
        }
    }

    private static class TagShort
    extends TagBase {
        short data;

        private TagShort() {
        }

        @Override
        int getType() {
            return 2;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagShort();
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=2=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseShort(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagShort)nbt).func_150289_e();
        }
    }

    private static class TagByte
    extends TagBase {
        byte data;

        private TagByte() {
        }

        @Override
        int getType() {
            return 1;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagByte(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=1=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseByte(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagByte)nbt).func_150290_f();
        }
    }

    private static class TagFloat
    extends TagBase {
        float data;

        private TagFloat() {
        }

        @Override
        int getType() {
            return 5;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagFloat(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=5=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseFloat(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagFloat)nbt).func_150288_h();
        }
    }

    private static class TagDouble
    extends TagBase {
        double data;

        private TagDouble() {
        }

        @Override
        int getType() {
            return 5;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagDouble(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=5=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseDouble(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagDouble)nbt).func_150286_g();
        }
    }

    private static class TagInt
    extends TagBase {
        int data;

        private TagInt() {
        }

        @Override
        int getType() {
            return 3;
        }

        @Override
        NBTBase getNBT() {
            return new NBTTagInt(this.data);
        }

        @Override
        void getTagLines(String tagName, List<String> lines) {
            lines.add("TAG=3=" + tagName + "{" + this.data + "}");
        }

        @Override
        void parseFromLines(List<String> lines) {
            Iterator<String> it = lines.iterator();
            String line = it.next();
            it.remove();
            String data = line.split("\\{", -1)[1];
            data = data.split("\\}")[0];
            this.data = NBTTools.safeParseInt(data);
        }

        @Override
        void createFromNBT(NBTBase nbt) {
            this.data = ((NBTTagInt)nbt).func_150287_d();
        }
    }

    private static abstract class TagBase {
        private TagBase() {
        }

        abstract int getType();

        abstract NBTBase getNBT();

        abstract void getTagLines(String var1, List<String> var2);

        abstract void parseFromLines(List<String> var1);

        abstract void createFromNBT(NBTBase var1);
    }
}

