/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class Trade {
    protected ItemStack[] input = new ItemStack[this.size()];
    protected ItemStack[] output = new ItemStack[this.size()];

    public int size() {
        return 9;
    }

    public ItemStack getInputStack(int index) {
        return this.input[index];
    }

    public ItemStack getOutputStack(int index) {
        return this.output[index];
    }

    public void setInputStack(int index, ItemStack stack) {
        this.input[index] = stack;
    }

    public void setOutputStack(int index, ItemStack stack) {
        this.output[index] = stack;
    }

    public void performTrade(EntityPlayer player, IInventory storage) {
        List<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack temp : this.input) {
            if (temp == null) continue;
            list.add(temp.func_77946_l());
        }
        list = InventoryTools.compactStackList3(list);
        for (ItemStack stack : list) {
            if (InventoryTools.getCountOf((IInventory)player.field_71071_by, -1, stack) >= stack.field_77994_a) continue;
            return;
        }
        this.doTrade(player, storage);
    }

    protected void doTrade(EntityPlayer player, IInventory storage) {
        for (ItemStack inputStack : this.input) {
            ItemStack result;
            if (inputStack == null || (result = InventoryTools.removeItems((IInventory)player.field_71071_by, -1, inputStack, inputStack.field_77994_a)) == null || storage == null) continue;
            InventoryTools.mergeItemStack(storage, result, -1);
        }
        for (ItemStack outputStack : this.output) {
            if (outputStack == null) continue;
            outputStack = storage != null ? InventoryTools.removeItems(storage, -1, outputStack, outputStack.field_77994_a) : outputStack.func_77946_l();
            if ((outputStack = InventoryTools.mergeItemStack((IInventory)player.field_71071_by, outputStack, -1)) == null || player.field_70170_p.field_72995_K) continue;
            InventoryTools.dropItemInWorld(player.field_70170_p, outputStack, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag;
        int i;
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            itemTag = InventoryTools.writeItemStack(this.input[i]);
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("inputItems", (NBTBase)list);
        list = new NBTTagList();
        for (i = 0; i < this.output.length; ++i) {
            if (this.output[i] == null) continue;
            itemTag = InventoryTools.writeItemStack(this.output[i]);
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("outputItems", (NBTBase)list);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag;
        NBTTagList inputList = tag.func_150295_c("inputItems", 10);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            itemTag = inputList.func_150305_b(i);
            this.input[itemTag.func_74762_e((String)"slot")] = InventoryTools.readItemStack(itemTag);
        }
        NBTTagList outputList = tag.func_150295_c("outputItems", 10);
        for (int i = 0; i < outputList.func_74745_c(); ++i) {
            itemTag = outputList.func_150305_b(i);
            this.output[itemTag.func_74762_e((String)"slot")] = InventoryTools.readItemStack(itemTag);
        }
    }
}

