/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.inventory.InventoryBasic;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.container.ContainerTownHall;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;

public class TileTownHall
extends TileOwned
implements IInventory,
IInteractableTile {
    public boolean alarmActive = false;
    private int broadcastRange = 80;
    private int updateDelayTicks = 0;
    private List<NpcDeathEntry> deathNotices = new ArrayList<NpcDeathEntry>();
    private final InventoryBasic inventory = new InventoryBasic(27);
    private List<ContainerTownHall> viewers = new ArrayList<ContainerTownHall>();

    public TileTownHall() {
        super("owner");
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateDelayTicks;
        if (this.updateDelayTicks <= 0) {
            this.broadcast();
            this.updateDelayTicks = AWNPCStatics.townUpdateFreq;
        }
    }

    public void addViewer(ContainerTownHall viewer) {
        if (!this.viewers.contains((Object)viewer)) {
            this.viewers.add(viewer);
        }
    }

    public void removeViewer(ContainerTownHall viewer) {
        while (this.viewers.contains((Object)viewer)) {
            this.viewers.remove((Object)viewer);
        }
    }

    private void broadcast() {
        List<NpcPlayerOwned> npcs = this.getNpcsInArea();
        BlockPosition pos = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (NpcPlayerOwned npc : npcs) {
            if (!npc.canBeCommandedBy(this.getOwnerName())) continue;
            npc.handleTownHallBroadcast(this, pos);
        }
    }

    public void clearDeathNotices() {
        this.deathNotices.clear();
        this.informViewers();
    }

    public void informViewers() {
        for (ContainerTownHall cth : this.viewers) {
            cth.onTownHallDeathListUpdated();
        }
    }

    public void handleNpcDeath(NpcPlayerOwned npc, DamageSource source) {
        boolean canRes = true;
        NpcDeathEntry entry = new NpcDeathEntry(npc, source, canRes);
        this.deathNotices.add(entry);
        this.informViewers();
    }

    private List<NpcPlayerOwned> getNpcsInArea() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.broadcastRange), (double)(this.field_145848_d - this.broadcastRange / 2), (double)(this.field_145849_e - this.broadcastRange), (double)(this.field_145851_c + this.broadcastRange + 1), (double)(this.field_145848_d + this.broadcastRange / 2 + 1), (double)(this.field_145849_e + this.broadcastRange + 1));
        return this.field_145850_b.func_72872_a(NpcPlayerOwned.class, bb);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        NBTTagList entryList = tag.func_150295_c("deathNotices", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NpcDeathEntry entry = new NpcDeathEntry(entryList.func_150305_b(i));
            this.deathNotices.add(entry);
        }
        if (tag.func_74764_b("range")) {
            this.setRange(tag.func_74762_e("range"));
        }
        if (tag.func_74764_b("alarmActive")) {
            this.alarmActive = tag.func_74767_n("alarmActive");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        NBTTagList entryList = new NBTTagList();
        for (NpcDeathEntry entry : this.deathNotices) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("deathNotices", (NBTBase)entryList);
        tag.func_74768_a("range", this.broadcastRange);
        tag.func_74757_a("alarmActive", this.alarmActive);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack stack = this.inventory.func_70298_a(var1, var2);
        if (stack != null) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.inventory.func_94041_b(var1, var2);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 41, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public List<NpcDeathEntry> getDeathList() {
        return this.deathNotices;
    }

    public int getRange() {
        return this.broadcastRange;
    }

    public void setRange(int val) {
        this.broadcastRange = val < AWNPCStatics.townMaxRange ? val : AWNPCStatics.townMaxRange;
    }

    public static class NpcDeathEntry {
        public ItemStack stackToSpawn;
        public String npcType;
        public String npcName;
        public String deathCause;
        public boolean resurrected;
        public boolean canRes;
        public boolean beingResurrected;

        public NpcDeathEntry(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public NpcDeathEntry(NpcPlayerOwned npc, DamageSource source, boolean canRes) {
            this.stackToSpawn = ItemNpcSpawner.getSpawnerItemForNpc(npc);
            this.npcType = npc.getNpcFullType();
            this.npcName = npc.func_94057_bL();
            this.deathCause = source.field_76373_n;
            this.canRes = canRes;
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.stackToSpawn = InventoryTools.readItemStack(tag.func_74775_l("spawnerStack"));
            this.npcType = tag.func_74779_i("npcType");
            this.npcName = tag.func_74779_i("npcName");
            this.deathCause = tag.func_74779_i("deathCause");
            this.resurrected = tag.func_74767_n("resurrected");
            this.canRes = tag.func_74767_n("canRes");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("spawnerStack", (NBTBase)InventoryTools.writeItemStack(this.stackToSpawn));
            tag.func_74778_a("npcType", this.npcType);
            tag.func_74778_a("npcName", this.npcName);
            tag.func_74778_a("deathCause", this.deathCause);
            tag.func_74757_a("resurrected", this.resurrected);
            tag.func_74757_a("canRes", this.canRes);
            return tag;
        }
    }
}

