/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.block.Direction;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.container.ContainerTradeOrder;
import net.shadowmage.ancientwarfare.npc.trade.POTradeDepositEntry;
import net.shadowmage.ancientwarfare.npc.trade.POTradePoint;
import net.shadowmage.ancientwarfare.npc.trade.POTradeRestockData;
import net.shadowmage.ancientwarfare.npc.trade.POTradeRoute;
import net.shadowmage.ancientwarfare.npc.trade.POTradeWithdrawEntry;
import net.shadowmage.ancientwarfare.npc.trade.Trade;
import net.shadowmage.ancientwarfare.npc.trade.TradeList;

public class GuiTradeOrder
extends GuiContainerBase<ContainerTradeOrder> {
    private CompositeScrolled tradesArea;
    private CompositeScrolled routeArea;
    private CompositeScrolled restockArea;
    private Button tradeButton;
    private Button routeButton;
    private Button restockButton;
    private Button currentMode;

    public GuiTradeOrder(ContainerBase container) {
        super(container);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerTradeOrder)((Object)this.getContainer())).onClose();
        return super.onGuiCloseRequested();
    }

    @Override
    public void initElements() {
        this.tradesArea = new CompositeScrolled(this, 0, 24, this.field_146999_f, this.field_147000_g - 24 - 4 - 4 - 8 - 72);
        this.routeArea = new CompositeScrolled(this, 0, 24, this.field_146999_f, this.field_147000_g - 24 - 4 - 4 - 8 - 72);
        this.restockArea = new CompositeScrolled(this, 0, 24, this.field_146999_f, this.field_147000_g - 24 - 4 - 4 - 8 - 72);
        this.tradeButton = new Button(8, 8, 75, 12, "guistrings.npc.trades"){

            @Override
            protected void onPressed() {
                GuiTradeOrder.this.currentMode = GuiTradeOrder.this.tradeButton;
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.routeButton = new Button(83, 8, 75, 12, "guistrings.npc.route"){

            @Override
            protected void onPressed() {
                GuiTradeOrder.this.currentMode = GuiTradeOrder.this.routeButton;
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.restockButton = new Button(158, 8, 75, 12, "guistrings.npc.restock"){

            @Override
            protected void onPressed() {
                GuiTradeOrder.this.currentMode = GuiTradeOrder.this.restockButton;
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.tradeButton.setEnabled(false);
        this.routeButton.setEnabled(true);
        this.restockButton.setEnabled(true);
        this.currentMode = this.tradeButton;
        this.setTradeMode();
    }

    @Override
    public void setupElements() {
        this.clearElements();
        this.addGuiElement(this.tradeButton);
        this.addGuiElement(this.routeButton);
        this.addGuiElement(this.restockButton);
        if (this.currentMode == this.tradeButton) {
            this.setTradeMode();
        } else if (this.currentMode == this.routeButton) {
            this.setRouteMode();
        } else if (this.currentMode == this.restockButton) {
            this.setRestockMode();
        }
    }

    private void setTradeMode() {
        this.addGuiElement(this.tradesArea);
        this.tradeButton.setEnabled(false);
        this.routeButton.setEnabled(true);
        this.restockButton.setEnabled(true);
        this.setupTradeMode();
    }

    private void setRouteMode() {
        this.addGuiElement(this.routeArea);
        this.tradeButton.setEnabled(true);
        this.routeButton.setEnabled(false);
        this.restockButton.setEnabled(true);
        this.setupRouteMode();
    }

    private void setRestockMode() {
        this.addGuiElement(this.restockArea);
        this.tradeButton.setEnabled(true);
        this.routeButton.setEnabled(true);
        this.restockButton.setEnabled(false);
        this.setupRestockMode();
    }

    private void setupTradeMode() {
        this.tradesArea.clearElements();
        final TradeList tradeList = ((ContainerTradeOrder)((Object)this.getContainer())).orders.getTradeList();
        int totalHeight = 8;
        for (int i = 0; i < tradeList.size(); ++i) {
            totalHeight = this.addTrade((Trade)tradeList.get(i), i, totalHeight);
        }
        Button newTradeButton = new Button(8, totalHeight, this.field_146999_f - 20, 12, "guistrings.new_trade"){

            @Override
            protected void onPressed() {
                tradeList.addNewTrade();
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.tradesArea.addGuiElement(newTradeButton);
        this.tradesArea.setAreaSize(totalHeight += 12);
    }

    private int addTrade(Trade trade, int tradeIndex, int startHeight) {
        int gridX = 0;
        int gridY = 0;
        for (int i = 0; i < trade.size(); ++i) {
            int slotX = gridX * 18 + 8;
            int slotY = gridY * 18 + startHeight;
            this.addTradeInputSlot(trade, slotX, slotY, i);
            this.addTradeOutputSlot(trade, slotX += 63, slotY, i);
            if (++gridX < 3) continue;
            gridX = 0;
            ++gridY;
        }
        int startWidth = 62;
        if (trade.size() < 3) {
            startWidth += (trade.size() - 3) * 18;
        }
        this.tradesArea.addGuiElement(new Label(startWidth + 1, startHeight + (gridY + 1) * 5, ">"));
        this.addTradeControls(startWidth, startHeight, tradeIndex);
        this.tradesArea.addGuiElement(new Line(0, (startHeight += 18 * gridY) + 1, this.field_146999_f, startHeight + 1, 1, 255));
        return startHeight += 5;
    }

    private void addTradeControls(int startWidth, int startHeight, final int tradeNum) {
        final TradeList tradeList = ((ContainerTradeOrder)((Object)this.getContainer())).orders.getTradeList();
        int infoX = 2 * startWidth + 5;
        Button upButton = new Button(infoX, --startHeight, 55, 12, "guistrings.up"){

            @Override
            protected void onPressed() {
                tradeList.increment(tradeNum);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.tradesArea.addGuiElement(upButton);
        Button downButton = new Button(infoX, startHeight + 54 - 12, 55, 12, "guistrings.down"){

            @Override
            protected void onPressed() {
                tradeList.decrement(tradeNum);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.tradesArea.addGuiElement(downButton);
        Button delete = new Button(infoX, startHeight + 21, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                tradeList.remove(tradeNum);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.tradesArea.addGuiElement(delete);
    }

    private void addTradeInputSlot(final Trade trade, int x, int y, final int slotNum) {
        ItemStack stack = trade.getInputStack(slotNum);
        stack = stack == null ? null : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this){

            @Override
            public void onSlotClicked(ItemStack stack) {
                stack = stack == null ? null : stack.func_77946_l();
                this.setItem(stack);
                trade.setInputStack(slotNum, stack);
            }
        };
        if (stack == null) {
            slot.addTooltip("guistrings.npc.trade_input_slot");
        }
        this.tradesArea.addGuiElement(slot);
    }

    private void addTradeOutputSlot(final Trade trade, int x, int y, final int slotNum) {
        ItemStack stack = trade.getOutputStack(slotNum);
        stack = stack == null ? null : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this){

            @Override
            public void onSlotClicked(ItemStack stack) {
                stack = stack == null ? null : stack.func_77946_l();
                this.setItem(stack);
                trade.setOutputStack(slotNum, stack);
            }
        };
        if (stack == null) {
            slot.addTooltip("guistrings.npc.trade_output_slot");
        }
        this.tradesArea.addGuiElement(slot);
    }

    private void setupRouteMode() {
        this.routeArea.clearElements();
        POTradeRoute route = ((ContainerTradeOrder)((Object)this.getContainer())).orders.getRoute();
        int totalHeight = 8;
        for (int i = 0; i < route.size(); ++i) {
            totalHeight = this.addRoutePoint(route.get(i), i, totalHeight);
        }
        this.routeArea.setAreaSize(totalHeight);
    }

    private int addRoutePoint(POTradePoint point, final int index, int startHeight) {
        BlockPosition pos = point.getPosition();
        Label blockName = new Label(8, startHeight, "Unknown Block");
        Label posLabel = new Label(8, startHeight + 12, pos.toString());
        if (this.player.field_70170_p.func_72899_e(pos.x, pos.y, pos.z)) {
            blockName.setText(this.player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z).func_149739_a());
        }
        this.routeArea.addGuiElement(blockName);
        this.routeArea.addGuiElement(posLabel);
        Button up = new Button(120, startHeight, 55, 12, "guistrings.up"){

            @Override
            protected void onPressed() {
                POTradeRoute route = ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRoute();
                route.decrementRoutePoint(index);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.routeArea.addGuiElement(up);
        Button down = new Button(120, startHeight + 12 + 12, 55, 12, "guistrings.down"){

            @Override
            protected void onPressed() {
                POTradeRoute route = ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRoute();
                route.incrementRoutePoint(index);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.routeArea.addGuiElement(down);
        Button delete = new Button(120, startHeight + 12, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                POTradeRoute route = ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRoute();
                route.deleteRoutePoint(index);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.routeArea.addGuiElement(delete);
        Checkbox upkeep = new Checkbox(179, startHeight, 12, 12, "guistrings.upkeep"){

            @Override
            public void onToggled() {
                POTradeRoute route = ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRoute();
                route.setUpkeep(index, this.checked());
            }
        };
        upkeep.setChecked(point.shouldUpkeep());
        this.routeArea.addGuiElement(upkeep);
        Label delayLabel = new Label(179, startHeight + 12 + 1, "guistrings.delay");
        this.routeArea.addGuiElement(delayLabel);
        NumberInput delayInput = new NumberInput(179, startHeight + 24, 55, point.getDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                POTradeRoute route = ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRoute();
                route.setPointDelay(index, (int)value);
            }
        };
        delayInput.setIntegerValue();
        this.routeArea.addGuiElement(delayInput);
        this.routeArea.addGuiElement(new Line(0, (startHeight += 36) + 2, this.field_146999_f, startHeight + 2, 1, 255));
        return startHeight += 5;
    }

    private void setupRestockMode() {
        final POTradeRestockData restock = ((ContainerTradeOrder)((Object)this.getContainer())).orders.getRestockData();
        this.restockArea.clearElements();
        int totalHeight = 8;
        this.restockArea.addGuiElement(new Label(120, totalHeight, "guistrings.deposit").setRenderCentered());
        this.restockArea.addGuiElement(new Label(70, totalHeight += 12, restock.getDepositPoint() == null ? "guistrings.none" : restock.getDepositPoint().toString()));
        this.restockArea.addGuiElement(new Label(8, totalHeight, "guistrings.position"));
        this.restockArea.addGuiElement(new Label(8, totalHeight += 12, "guistrings.side"));
        this.restockArea.addGuiElement(new Button(70, totalHeight, 55, 12, Direction.getDirectionFor(restock.getDepositSide()).getTranslationKey()){

            @Override
            protected void onPressed() {
                int dir = restock.getDepositSide() + 1;
                if (dir >= 6) {
                    dir = 0;
                }
                this.setText(Direction.getDirectionFor(restock.getDepositSide()).getTranslationKey());
                restock.setDepositPoint(restock.getDepositPoint(), dir);
            }
        });
        totalHeight += 16;
        List<POTradeDepositEntry> depositList = restock.getDepositList();
        for (int i = 0; i < depositList.size(); ++i) {
            totalHeight = this.addDepositEntry(depositList.get(i), i, totalHeight);
        }
        Button newDepositButton = new Button(8, totalHeight, 120, 12, "guistrings.new_deposit"){

            @Override
            protected void onPressed() {
                restock.addDepositEntry();
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.restockArea.addGuiElement(newDepositButton);
        this.restockArea.addGuiElement(new Line(0, totalHeight += 14, this.field_146999_f, totalHeight, 2, 255));
        this.restockArea.addGuiElement(new Label(120, totalHeight += 4, "guistrings.withdraw").setRenderCentered());
        this.restockArea.addGuiElement(new Label(70, totalHeight += 12, restock.getWithdrawPoint() == null ? "guistrings.none" : restock.getWithdrawPoint().toString()));
        this.restockArea.addGuiElement(new Label(8, totalHeight, "guistrings.position"));
        this.restockArea.addGuiElement(new Label(8, totalHeight += 12, "guistrings.side"));
        this.restockArea.addGuiElement(new Button(70, totalHeight, 55, 12, Direction.getDirectionFor(restock.getWithdrawSide()).getTranslationKey()){

            @Override
            protected void onPressed() {
                int dir = restock.getWithdrawSide() + 1;
                if (dir >= 6) {
                    dir = 0;
                }
                this.setText(Direction.getDirectionFor(restock.getWithdrawSide()).getTranslationKey());
                restock.setWithdrawPoint(restock.getWithdrawPoint(), dir);
            }
        });
        totalHeight += 16;
        List<POTradeWithdrawEntry> withdrawList = restock.getWithdrawList();
        for (int i = 0; i < withdrawList.size(); ++i) {
            totalHeight = this.addWithdrawEntry(withdrawList.get(i), i, totalHeight);
        }
        Button newWithdrawButton = new Button(8, totalHeight, 120, 12, "guistrings.new_withdraw"){

            @Override
            protected void onPressed() {
                restock.addWithdrawEntry();
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.restockArea.addGuiElement(newWithdrawButton);
        this.restockArea.setAreaSize(totalHeight += 14);
    }

    private int addDepositEntry(final POTradeDepositEntry entry, final int index, int startHeight) {
        ItemSlot slot = new ItemSlot(8, startHeight, entry.getFilter(), this){

            @Override
            public void onSlotClicked(ItemStack stack) {
                stack = stack == null ? null : stack.func_77946_l();
                entry.setFilter(stack);
                this.setItem(stack);
            }
        };
        this.restockArea.addGuiElement(slot);
        Button typeButton = new Button(30, startHeight + 3, 120, 12, entry.getType().toString()){

            @Override
            protected void onPressed() {
                entry.toggleType();
                this.setText(entry.getType().toString());
            }
        };
        this.restockArea.addGuiElement(typeButton);
        Button deleteButton = new Button(154, startHeight + 3, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRestockData().removeDepositEntry(index);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.restockArea.addGuiElement(deleteButton);
        startHeight += 18;
        return startHeight += 5;
    }

    private int addWithdrawEntry(final POTradeWithdrawEntry entry, final int index, int startHeight) {
        ItemSlot slot = new ItemSlot(8, startHeight, entry.getFilter(), this){

            @Override
            public void onSlotClicked(ItemStack stack) {
                stack = stack == null ? null : stack.func_77946_l();
                entry.setFilter(stack);
                this.setItem(stack);
            }
        };
        this.restockArea.addGuiElement(slot);
        Button typeButton = new Button(30, startHeight + 3, 120, 12, entry.getType().toString()){

            @Override
            protected void onPressed() {
                entry.toggleType();
                this.setText(entry.getType().toString());
            }
        };
        this.restockArea.addGuiElement(typeButton);
        Button deleteButton = new Button(154, startHeight + 3, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                ((ContainerTradeOrder)((Object)GuiTradeOrder.this.getContainer())).orders.getRestockData().removeWithdrawEntry(index);
                GuiTradeOrder.this.refreshGui();
            }
        };
        this.restockArea.addGuiElement(deleteButton);
        startHeight += 18;
        return startHeight += 5;
    }
}

