/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.faction;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.faction.FactionEntry;
import net.shadowmage.ancientwarfare.npc.gamedata.FactionData;
import net.shadowmage.ancientwarfare.npc.network.PacketFactionUpdate;

public class FactionTracker {
    public static final FactionTracker INSTANCE = new FactionTracker();
    private static final String DEFAULT = "client_entry";
    private FactionEntry clientEntry = new FactionEntry("client_entry");

    private FactionTracker() {
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        this.onPlayerLogin(evt.player);
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent evt) {
        this.clientEntry = new FactionEntry(DEFAULT);
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
        this.clientEntry = new FactionEntry(DEFAULT);
    }

    private void onPlayerLogin(EntityPlayer player) {
        FactionData data = AWGameData.INSTANCE.getData(player.field_70170_p, FactionData.class);
        data.onPlayerLogin(player);
        this.sendFactionEntry(player, data);
    }

    public void adjustStandingFor(World world, String playerName, String factionName, int adjustment) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Cannot adjust standing on client world!");
        }
        FactionData data = AWGameData.INSTANCE.getData(world, FactionData.class);
        data.adjustStandingFor(playerName, factionName, adjustment);
        this.sendFactionUpdate(world, playerName, factionName, data);
    }

    public void setStandingFor(World world, String playerName, String factionName, int setting) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Cannot set standing on client world!");
        }
        FactionData data = AWGameData.INSTANCE.getData(world, FactionData.class);
        data.setStandingFor(playerName, factionName, setting);
        this.sendFactionUpdate(world, playerName, factionName, data);
    }

    public int getStandingFor(World world, String playerName, String factionName) {
        if (world.field_72995_K) {
            if (this.clientEntry != null) {
                return this.clientEntry.getStandingFor(factionName);
            }
            throw new RuntimeException("Client side faction data was null while attempting lookup for: " + playerName + " for faction: " + factionName + " for client world: " + world);
        }
        FactionData data = AWGameData.INSTANCE.getData(world, FactionData.class);
        return data.getStandingFor(playerName, factionName);
    }

    private void sendFactionEntry(EntityPlayer player, FactionData data) {
        FactionEntry entry = data.getEntryFor(player.func_70005_c_());
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound initTag = entry.writeToNBT(new NBTTagCompound());
        tag.func_74782_a("factionInit", (NBTBase)initTag);
        PacketFactionUpdate pkt = new PacketFactionUpdate(tag);
        NetworkHandler.sendToPlayer((EntityPlayerMP)player, pkt);
    }

    private void sendFactionUpdate(World world, String playerName, String factionName, FactionData data) {
        EntityPlayer player = world.func_72924_a(playerName);
        if (player != null && player instanceof EntityPlayerMP) {
            int standing = data.getStandingFor(playerName, factionName);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound updateTag = new NBTTagCompound();
            updateTag.func_74778_a("faction", factionName);
            updateTag.func_74768_a("standing", standing);
            tag.func_74782_a("factionUpdate", (NBTBase)updateTag);
            PacketFactionUpdate pkt = new PacketFactionUpdate(tag);
            NetworkHandler.sendToPlayer((EntityPlayerMP)player, pkt);
        }
    }

    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("factionUpdate")) {
            this.handleClientFactionUpdate(tag.func_74775_l("factionUpdate"));
        }
        if (tag.func_74764_b("factionInit")) {
            this.handleClientFactionInit(tag.func_74775_l("factionInit"));
        }
    }

    private void handleClientFactionUpdate(NBTTagCompound tag) {
        String faction = tag.func_74779_i("faction");
        int standing = tag.func_74762_e("standing");
        this.clientEntry.setStandingFor(faction, standing);
    }

    private void handleClientFactionInit(NBTTagCompound tag) {
        this.clientEntry = new FactionEntry(tag);
    }
}

