/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.IconRotationMap;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.item.AWNpcItemLoader;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class BlockTownHall
extends Block
implements BlockRotationHandler.IRotatableBlock {
    private final IconRotationMap iconMap = new IconRotationMap();

    public BlockTownHall() {
        super(Material.field_151576_e);
        this.func_149647_a(AWNpcItemLoader.npcTab);
        this.func_149711_c(2.0f);
        this.setIcon(BlockRotationHandler.RelativeSide.TOP, "ancientwarfare:npc/town_hall_top");
        this.setIcon(BlockRotationHandler.RelativeSide.BOTTOM, "ancientwarfare:npc/town_hall_bottom");
        this.setIcon(BlockRotationHandler.RelativeSide.LEFT, "ancientwarfare:npc/town_hall_side");
        this.setIcon(BlockRotationHandler.RelativeSide.RIGHT, "ancientwarfare:npc/town_hall_side");
        this.setIcon(BlockRotationHandler.RelativeSide.FRONT, "ancientwarfare:npc/town_hall_side");
        this.setIcon(BlockRotationHandler.RelativeSide.REAR, "ancientwarfare:npc/town_hall_side");
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        IInventory tile = (IInventory)world.func_147438_o(x, y, z);
        if (tile != null) {
            InventoryTools.dropInventoryInWorld(world, tile, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconMap.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconMap.getIcon(this, meta, side);
    }

    @Override
    public BlockTownHall setIcon(BlockRotationHandler.RelativeSide side, String texName) {
        this.iconMap.setIcon(this, side, texName);
        return this;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileTownHall();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInteractableTile && ((IInteractableTile)te).onBlockClicked(player);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileTownHall tileTownHall = (TileTownHall)world.func_147438_o(x, y, z);
            tileTownHall.alarmActive = world.func_72864_z(x, y, z);
        }
    }
}

