/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.faction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.util.ChunkCoordinates;
import net.shadowmage.ancientwarfare.npc.ai.AIHelper;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIFactionRangedAttack
extends NpcAIAttack<NpcBase> {
    private final IRangedAttackMob rangedAttacker;
    private double attackDistanceSq = 256.0;

    public NpcAIFactionRangedAttack(NpcBase npc) {
        super(npc);
        this.rangedAttacker = (IRangedAttackMob)npc;
        this.moveSpeed = 1.0;
    }

    @Override
    protected boolean shouldCloseOnTarget(double dist) {
        return dist > this.attackDistanceSq || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    @Override
    protected void doAttack(double dist) {
        double homeDist = this.npc.getDistanceSqFromHome();
        if (homeDist > 9.0 && dist < 64.0) {
            this.npc.addAITask(512);
            ChunkCoordinates home = this.npc.func_110172_bL();
            this.moveToPosition(home.field_71574_a, home.field_71572_b, home.field_71573_c, homeDist);
        } else {
            this.npc.removeAITask(512);
            this.npc.func_70661_as().func_75499_g();
        }
        if (this.getAttackDelay() <= 0) {
            int val = AIHelper.doQuiverBowThing((EntityLiving)this.npc, (Entity)this.getTarget());
            if (val > 0) {
                this.setAttackDelay(val);
                return;
            }
            float pwr = (float)(this.attackDistanceSq / dist);
            pwr = pwr < 0.1f ? 0.1f : (pwr > 1.0f ? 1.0f : pwr);
            this.rangedAttacker.func_82196_d(this.getTarget(), pwr);
            this.setAttackDelay(35);
        }
    }
}

