/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;

public class BlockTools {
    public static int turnRight(int dir) {
        return (dir + 1) % 4;
    }

    public static int turnLeft(int dir) {
        return (dir + 3) % 4;
    }

    public static int turnAround(int dir) {
        return (dir + 2) % 4;
    }

    public static float rotateFloatX(float x, float z, int turns) {
        float x1 = x;
        float z1 = z;
        for (int i = 0; i < turns; ++i) {
            z = x1;
            x1 = x = 1.0f - z1;
            z1 = z;
        }
        return x;
    }

    public static float rotateFloatZ(float x, float z, int turns) {
        float x1 = x;
        float z1 = z;
        for (int i = 0; i < turns; ++i) {
            z = x1;
            x1 = x = 1.0f - z1;
            z1 = z;
        }
        return z;
    }

    public static BlockPosition getAverageOf(BlockPosition ... positions) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        int count = 0;
        for (BlockPosition pos : positions) {
            x += (float)pos.x;
            y += (float)pos.y;
            z += (float)pos.z;
            ++count;
        }
        if (count > 0) {
            x /= (float)count;
            y /= (float)count;
            z /= (float)count;
        }
        return new BlockPosition(x, y, z);
    }

    public static BlockPosition getBlockClickedOn(EntityPlayer player, World world, boolean offset) {
        float vectorZ;
        float vectorY;
        double reachLength;
        float var16;
        float scaleFactor = 1.0f;
        float rotPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scaleFactor;
        float rotYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scaleFactor;
        double testX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scaleFactor;
        double testY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scaleFactor + 1.62 - (double)player.field_70129_M;
        double testZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scaleFactor;
        Vec3 testVector = Vec3.func_72443_a((double)testX, (double)testY, (double)testZ);
        float var14 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float vectorX = var15 * (var16 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180))));
        Vec3 testVectorFar = testVector.func_72441_c((double)vectorX * (reachLength = 5.0), (double)(vectorY = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)))) * reachLength, (double)(vectorZ = var14 * var16) * reachLength);
        MovingObjectPosition testHitPosition = world.func_72901_a(testVector, testVectorFar, true);
        if (testHitPosition == null) {
            return null;
        }
        Vec3 var25 = player.func_70676_i(scaleFactor);
        float var27 = 1.0f;
        List entitiesPossiblyHitByVector = world.func_72839_b((Entity)player, player.field_70121_D.func_72321_a(var25.field_72450_a * reachLength, var25.field_72448_b * reachLength, var25.field_72449_c * reachLength).func_72314_b((double)var27, (double)var27, (double)var27));
        for (Entity testEntity : entitiesPossiblyHitByVector) {
            float bbExpansionSize;
            AxisAlignedBB entityBB;
            if (!testEntity.func_70067_L() || !(entityBB = testEntity.field_70121_D.func_72314_b((double)(bbExpansionSize = testEntity.func_70111_Y()), (double)bbExpansionSize, (double)bbExpansionSize)).func_72318_a(testVector)) continue;
            return new BlockPosition(testEntity.field_70165_t, testEntity.field_70163_u, testEntity.field_70161_v);
        }
        int var42 = testHitPosition.field_72311_b;
        int var43 = testHitPosition.field_72312_c;
        int var44 = testHitPosition.field_72309_d;
        if (offset) {
            switch (testHitPosition.field_72310_e) {
                case 0: {
                    --var43;
                    break;
                }
                case 1: {
                    ++var43;
                    break;
                }
                case 2: {
                    --var44;
                    break;
                }
                case 3: {
                    ++var44;
                    break;
                }
                case 4: {
                    --var42;
                    break;
                }
                case 5: {
                    ++var42;
                }
            }
        }
        return new BlockPosition(var42, var43, var44);
    }

    public static BlockPosition rotateAroundOrigin(BlockPosition pos, int turns) {
        for (int i = 0; i < turns; ++i) {
            pos = BlockTools.rotateAroundOrigin(pos);
        }
        return pos;
    }

    public static BlockPosition rotateAroundOrigin(BlockPosition pos) {
        return new BlockPosition(-pos.z, pos.y, pos.x);
    }

    public static boolean isPositionWithinBounds(BlockPosition test, BlockPosition pos1, BlockPosition pos2) {
        int max;
        int min;
        if (pos1.x < pos2.x) {
            min = pos1.x;
            max = pos2.x;
        } else {
            min = pos2.x;
            max = pos1.x;
        }
        if (test.x >= min && test.x <= max) {
            if (pos1.y < pos2.y) {
                min = pos1.y;
                max = pos2.y;
            } else {
                min = pos2.y;
                max = pos1.y;
            }
            if (test.y >= min && test.y <= max) {
                if (pos1.z < pos2.z) {
                    min = pos1.z;
                    max = pos2.z;
                } else {
                    min = pos2.z;
                    max = pos1.z;
                }
                if (test.z >= min && test.z <= max) {
                    return true;
                }
            }
        }
        return false;
    }

    public static BlockPosition getMin(BlockPosition pos1, BlockPosition pos2) {
        return new BlockPosition(Math.min(pos1.x, pos2.x), Math.min(pos1.y, pos2.y), Math.min(pos1.z, pos2.z));
    }

    public static BlockPosition getMax(BlockPosition pos1, BlockPosition pos2) {
        return new BlockPosition(Math.max(pos1.x, pos2.x), Math.max(pos1.y, pos2.y), Math.max(pos1.z, pos2.z));
    }

    public static int getPlayerFacingFromYaw(float rotation) {
        double yaw;
        for (yaw = (double)rotation; yaw < 0.0; yaw += 360.0) {
        }
        while (yaw >= 360.0) {
            yaw -= 360.0;
        }
        double adjYaw = yaw + 45.0;
        adjYaw *= 4.0;
        return MathHelper.func_76128_c((double)(adjYaw /= 360.0)) % 4;
    }

    public static ForgeDirection getForgeDirectionFromFacing(int facing) {
        switch (facing) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static BlockPosition rotateInArea(BlockPosition pos, int xSize, int zSize, int turns) {
        int xSize1 = xSize;
        int zSize1 = zSize;
        int x = pos.x;
        int z = pos.z;
        if (x >= xSize) {
            x = 0;
        }
        if (z >= zSize) {
            z = 0;
        }
        int x1 = x;
        int z1 = z;
        for (int i = 0; i < turns; ++i) {
            x = zSize - 1 - z1;
            z = x1;
            x1 = x;
            z1 = z;
            xSize = zSize1;
            zSize = xSize1;
            xSize1 = xSize;
            zSize1 = zSize;
        }
        return new BlockPosition(x, pos.y, z);
    }

    public static boolean breakBlockAndDrop(World world, EntityPlayer player, int x, int y, int z) {
        return BlockTools.breakBlock(world, player, x, y, z, 0, true);
    }

    public static boolean breakBlock(World world, EntityPlayer player, int x, int y, int z, int fortune, boolean doDrop) {
        if (world.field_72995_K) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (doDrop) {
            int meta = world.func_72805_g(x, y, z);
            if (!BlockTools.canBreakBlock(world, player, x, y, z, block, meta)) {
                return false;
            }
            block.func_149697_b(world, x, y, z, meta, fortune);
        }
        return world.func_147468_f(x, y, z);
    }

    public static boolean canBreakBlock(World world, EntityPlayer player, int x, int y, int z, Block block, int meta) {
        return !AWCoreStatics.fireBlockBreakEvents || !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(x, y, z, world, block, meta, player));
    }
}

