/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.Trig;

public final class BlockPosition {
    public final int x;
    public final int y;
    public final int z;

    public BlockPosition() {
        this(0, 0, 0);
    }

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPosition(int x, int y, int z, int dir) {
        this.y = y;
        if (dir == 0) {
            this.x = x;
            this.z = z + 1;
        } else if (dir == 1) {
            this.x = x - 1;
            this.z = z;
        } else if (dir == 2) {
            this.x = x;
            this.z = z - 1;
        } else {
            this.x = x + 1;
            this.z = z;
        }
    }

    public BlockPosition(double x, double y, double z) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
    }

    public BlockPosition(NBTTagCompound tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
    }

    public BlockPosition(BlockPosition pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public BlockPosition(MovingObjectPosition pos) {
        switch (pos.field_72310_e) {
            case 0: {
                this.x = pos.field_72311_b;
                this.y = pos.field_72312_c - 1;
                this.z = pos.field_72309_d;
                break;
            }
            case 1: {
                this.x = pos.field_72311_b;
                this.y = pos.field_72312_c + 1;
                this.z = pos.field_72309_d;
                break;
            }
            case 2: {
                this.x = pos.field_72311_b;
                this.y = pos.field_72312_c;
                this.z = pos.field_72309_d - 1;
                break;
            }
            case 3: {
                this.x = pos.field_72311_b;
                this.y = pos.field_72312_c;
                this.z = pos.field_72309_d + 1;
                break;
            }
            case 4: {
                this.x = pos.field_72311_b - 1;
                this.y = pos.field_72312_c;
                this.z = pos.field_72309_d;
                break;
            }
            default: {
                this.x = pos.field_72311_b + 1;
                this.y = pos.field_72312_c;
                this.z = pos.field_72309_d;
            }
        }
    }

    public final float getCenterDistanceFrom(double x, double y, double z) {
        return Trig.getDistance(x, y, z, (double)this.x + 0.5, this.y, (double)this.z + 0.5);
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        return tag;
    }

    public final BlockPosition offsetBy(BlockPosition offsetVector) {
        return new BlockPosition(this.x + offsetVector.x, this.y + offsetVector.y, this.z + offsetVector.z);
    }

    public final BlockPosition offset(int x, int y, int z) {
        return new BlockPosition(this.x + x, this.y + y, this.z + z);
    }

    public final BlockPosition sub(BlockPosition sub) {
        return new BlockPosition(this.x - sub.x, this.y - sub.y, this.z - sub.z);
    }

    public final BlockPosition moveRight(int facing, int amt) {
        return this.moveForward(BlockTools.turnRight(facing), amt);
    }

    public final BlockPosition moveBack(int facing, int amt) {
        return this.moveForward(BlockTools.turnAround(facing), amt);
    }

    public final BlockPosition moveLeft(int facing, int amt) {
        return this.moveForward(BlockTools.turnLeft(facing), amt);
    }

    public final BlockPosition moveForward(int facing, int amt) {
        if (facing == 0) {
            return new BlockPosition(this.x, this.y, this.z + amt);
        }
        if (facing == 1) {
            return new BlockPosition(this.x - amt, this.y, this.z);
        }
        if (facing == 2) {
            return new BlockPosition(this.x, this.y, this.z - amt);
        }
        return new BlockPosition(this.x + amt, this.y, this.z);
    }

    public final BlockPosition moveUp(int amt) {
        return new BlockPosition(this.x, this.y + amt, this.z);
    }

    public final boolean equals(BlockPosition pos) {
        return pos != null && this.x == pos.x && this.y == pos.y && this.z == pos.z;
    }

    public final BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z);
    }

    public final String toString() {
        return "X:" + this.x + " Y:" + this.y + " Z:" + this.z;
    }

    public Block get(int dimension) {
        World world = AncientWarfareCore.proxy.getWorld(dimension);
        if (world == null) {
            return null;
        }
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public BlockPosition getMin(BlockPosition position) {
        int minX = position.x < this.x ? position.x : this.x;
        int minY = position.y < this.y ? position.y : this.y;
        int minZ = position.z < this.z ? position.z : this.z;
        return new BlockPosition(minX, minY, minZ);
    }

    public BlockPosition getMax(BlockPosition position) {
        int maxX = position.x > this.x ? position.x : this.x;
        int maxY = position.y > this.y ? position.y : this.y;
        int maxZ = position.z > this.z ? position.z : this.z;
        return new BlockPosition(maxX, maxY, maxZ);
    }

    public final int hashCode() {
        int prime = 16777619;
        long result = 0x1000193 ^ this.x;
        result = 16777619L * result ^ (long)this.z;
        result = 16777619L * result ^ (long)this.y;
        return Long.hashCode(result + 17L);
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof BlockPosition && this.equals((BlockPosition)obj);
    }
}

