/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.interfaces;

import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;

public interface IWorkSite
extends ITorque.ITorqueTile {
    public boolean hasWork();

    public void addEnergyFromWorker(IWorker var1);

    public void addEnergyFromPlayer(EntityPlayer var1);

    public WorkType getWorkType();

    public Team getTeam();

    public EnumSet<WorksiteUpgrade> getUpgrades();

    public EnumSet<WorksiteUpgrade> getValidUpgrades();

    public void addUpgrade(WorksiteUpgrade var1);

    public void removeUpgrade(WorksiteUpgrade var1);

    public void onBlockBroken();

    public static final class WorksiteImplementation {
        private WorksiteImplementation() {
        }

        public static double getEnergyPerActivation(double efficiencyBonusFactor) {
            return AWCoreStatics.energyPerWorkUnit * 1.0 - efficiencyBonusFactor;
        }

        public static double getEfficiencyFactor(EnumSet<WorksiteUpgrade> upgrades) {
            double efficiencyBonusFactor = 0.0;
            if (upgrades.contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_1)) {
                efficiencyBonusFactor += 0.05;
            }
            if (upgrades.contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_2)) {
                efficiencyBonusFactor += 0.1;
            }
            if (upgrades.contains((Object)WorksiteUpgrade.TOOL_QUALITY_1)) {
                efficiencyBonusFactor += 0.05;
            }
            if (upgrades.contains((Object)WorksiteUpgrade.TOOL_QUALITY_2)) {
                efficiencyBonusFactor += 0.15;
            }
            if (upgrades.contains((Object)WorksiteUpgrade.TOOL_QUALITY_3)) {
                efficiencyBonusFactor += 0.25;
            }
            return efficiencyBonusFactor;
        }
    }

    public static enum WorkType {
        MINING("work_type.mining"),
        FARMING("work_type.farming"),
        FORESTRY("work_type.forestry"),
        CRAFTING("work_type.crafting"),
        RESEARCH("work_type.research"),
        NONE("work_type.none");

        public final String regName;

        private WorkType(String regName) {
            this.regName = regName;
        }
    }
}

