/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

public class TexturedRectangle
extends GuiElement {
    ResourceLocation texture;
    int tx;
    int ty;
    int u;
    int v;
    int uw;
    int vh;
    float u1;
    float v1;
    float u2;
    float v2;

    public TexturedRectangle(int topLeftX, int topLeftY, int width, int height, String texture, int tx, int ty, int u, int v, int uw, int vh) {
        super(topLeftX, topLeftY, width, height);
        this.tx = tx;
        this.ty = ty;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
        float perX = 1.0f / (float)tx;
        float perY = 1.0f / (float)ty;
        this.u1 = (float)u * perX;
        this.v1 = (float)v * perY;
        this.u2 = (float)(u + uw) * perX;
        this.v2 = (float)(v + vh) * perY;
        this.texture = new ResourceLocation("ancientwarfare", "textures/" + texture);
    }

    public TexturedRectangle(int topLeftX, int topLeftY, int width, int height, ResourceLocation texture, int tx, int ty, int u, int v, int uw, int vh) {
        super(topLeftX, topLeftY, width, height);
        this.tx = tx;
        this.ty = ty;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
        float perX = 1.0f / (float)tx;
        float perY = 1.0f / (float)ty;
        this.u1 = (float)u * perX;
        this.v1 = (float)v * perY;
        this.u2 = (float)(u + uw) * perX;
        this.v2 = (float)(v + vh) * perY;
        this.texture = texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible && this.texture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            RenderTools.renderTexturedQuad(this.renderX, this.renderY, this.renderX + this.width, this.renderY + this.height, this.u1, this.v1, this.u2, this.v2);
        }
    }
}

