/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockReed;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteUserBlocks;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteReedFarm
extends TileWorksiteUserBlocks {
    private final Set<BlockPosition> cocoaToPlant = new HashSet<BlockPosition>();
    private final Set<BlockPosition> cactusToPlant = new HashSet<BlockPosition>();
    private final Set<BlockPosition> reedToPlant = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToHarvest = new HashSet<BlockPosition>();
    private final Set<BlockPosition> cocoaToGrow = new HashSet<BlockPosition>();
    private int reedCount;
    private int cactusCount;
    private int cocoaCount;
    private int bonemealCount;

    public WorkSiteReedFarm() {
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(27);
        int[] frontIndices = helper.getIndiceArrayForSpread(3);
        int[] bottomIndices = helper.getIndiceArrayForSpread(3);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.FRONT, frontIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.BOTTOM, bottomIndices);
        ItemSlotFilter filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteReedFarm.this.isCocoDye(stack) || stack.func_77973_b() == Items.field_151120_aE || Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockCactus;
            }
        };
        this.inventory.setFilterForSlots(filter, frontIndices);
        filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteReedFarm.this.isBonemeal(stack);
            }
        };
        this.inventory.setFilterForSlots(filter, bottomIndices);
    }

    private boolean isCocoDye(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 3;
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.cocoaToPlant);
        this.validateCollection(this.blocksToHarvest);
        this.validateCollection(this.cactusToPlant);
        this.validateCollection(this.reedToPlant);
        this.validateCollection(this.cocoaToGrow);
    }

    @Override
    protected boolean processWork() {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (this.blocksToHarvest.isEmpty()) break block5;
                            Iterator<BlockPosition> it = this.blocksToHarvest.iterator();
                            while (it.hasNext()) {
                                BlockPosition p = it.next();
                                it.remove();
                                if (!this.harvestBlock(p)) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (this.cocoaCount <= 0 || this.cocoaToPlant.isEmpty()) break block7;
                        Iterator<BlockPosition> it = this.cocoaToPlant.iterator();
                        while (it.hasNext()) {
                            BlockPosition p = it.next();
                            it.remove();
                            if (!this.plantCocoa(p)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (this.reedCount <= 0 || this.reedToPlant.isEmpty()) break block8;
                    Iterator<BlockPosition> it = this.reedToPlant.iterator();
                    while (it.hasNext()) {
                        BlockPosition p = it.next();
                        it.remove();
                        if (!this.plantReeds(p)) continue;
                        return true;
                    }
                    break block6;
                }
                if (this.cactusCount <= 0 || this.cactusToPlant.isEmpty()) break block9;
                Iterator<BlockPosition> it = this.cactusToPlant.iterator();
                while (it.hasNext()) {
                    BlockPosition p = it.next();
                    it.remove();
                    if (!this.plantCactus(p)) continue;
                    return true;
                }
                break block6;
            }
            if (this.bonemealCount <= 0 || this.cocoaToGrow.isEmpty()) break block6;
            Iterator<BlockPosition> it = this.cocoaToGrow.iterator();
            while (it.hasNext()) {
                BlockPosition p = it.next();
                it.remove();
                if (!this.applyBonemeal(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean applyBonemeal(BlockPosition p) {
        Block block = this.field_145850_b.func_147439_a(p.x, p.y, p.z);
        if (block instanceof BlockCocoa && ((BlockCocoa)block).func_149851_a(this.field_145850_b, p.x, p.y, p.z, this.field_145850_b.field_72995_K)) {
            for (int i = 30; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null || !this.isBonemeal(stack)) continue;
                if (ItemDye.applyBonemeal((ItemStack)stack, (World)this.field_145850_b, (int)p.x, (int)p.y, (int)p.z, (EntityPlayer)this.getOwnerAsPlayer())) {
                    --this.bonemealCount;
                    if (stack.field_77994_a <= 0) {
                        this.func_70299_a(i, null);
                    }
                }
                if (((BlockCocoa)block).func_149851_a(this.field_145850_b, p.x, p.y, p.z, this.field_145850_b.field_72995_K)) {
                    this.cocoaToGrow.add(p);
                } else {
                    this.blocksToHarvest.add(p);
                }
                return true;
            }
        }
        return false;
    }

    private boolean harvestBlock(BlockPosition p) {
        Block block = this.field_145850_b.func_147439_a(p.x, p.y, p.z);
        if (block instanceof BlockCactus || block instanceof BlockReed || block instanceof BlockCocoa) {
            return this.harvestBlock(p.x, p.y, p.z, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
        }
        return false;
    }

    private boolean plantCactus(BlockPosition p) {
        if (!this.canReplace(p.x, p.y, p.z) || !Blocks.field_150434_aF.func_149718_j(this.field_145850_b, p.x, p.y, p.z)) {
            return false;
        }
        for (int i = 27; i < 30; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150434_aF) || !this.tryPlace(stack, p.x, p.y, p.z, ForgeDirection.UP)) continue;
            --this.cactusCount;
            return true;
        }
        return false;
    }

    private boolean plantReeds(BlockPosition p) {
        if (!this.canReplace(p.x, p.y, p.z) || !Blocks.field_150436_aH.func_149718_j(this.field_145850_b, p.x, p.y, p.z)) {
            return false;
        }
        for (int i = 27; i < 30; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Items.field_151120_aE || !this.tryPlace(stack, p.x, p.y, p.z, ForgeDirection.UP)) continue;
            --this.reedCount;
            return true;
        }
        return false;
    }

    private boolean plantCocoa(BlockPosition p) {
        if (!this.canReplace(p.x, p.y, p.z)) {
            return false;
        }
        ForgeDirection meta = null;
        if (this.isJungleLog(p.x - 1, p.y, p.z)) {
            meta = ForgeDirection.EAST;
        } else if (this.isJungleLog(p.x + 1, p.y, p.z)) {
            meta = ForgeDirection.WEST;
        } else if (this.isJungleLog(p.x, p.y, p.z - 1)) {
            meta = ForgeDirection.SOUTH;
        } else if (this.isJungleLog(p.x, p.y, p.z + 1)) {
            meta = ForgeDirection.NORTH;
        }
        if (meta == null) {
            return false;
        }
        for (int i = 27; i < 30; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !this.isCocoDye(stack) || !this.tryPlace(stack, p.x, p.y, p.z, meta)) continue;
            --this.cocoaCount;
            return true;
        }
        return false;
    }

    protected boolean isJungleLog(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150364_r && BlockLog.func_150165_c((int)this.field_145850_b.func_72805_g(x, y, z)) == 3;
    }

    @Override
    protected void countResources() {
        ItemStack stack;
        int i;
        this.cactusCount = 0;
        this.reedCount = 0;
        this.cocoaCount = 0;
        this.bonemealCount = 0;
        for (i = 27; i < 30; ++i) {
            stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (this.isCocoDye(stack)) {
                this.cocoaCount += stack.field_77994_a;
                continue;
            }
            if (stack.func_77973_b() == Items.field_151120_aE) {
                this.reedCount += stack.field_77994_a;
                continue;
            }
            if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockCactus)) continue;
            this.cactusCount += stack.field_77994_a;
        }
        for (i = 30; i < this.func_70302_i_(); ++i) {
            stack = this.func_70301_a(i);
            if (stack == null || !this.isBonemeal(stack)) continue;
            this.bonemealCount += stack.field_77994_a;
        }
    }

    @Override
    protected int[] getIndicesForPickup() {
        return this.inventory.getRawIndicesCombined(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 30, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected void scanBlockPosition(BlockPosition pos) {
        Block block = this.field_145850_b.func_147439_a(pos.x, pos.y, pos.z);
        if (block instanceof BlockCactus || block instanceof BlockReed) {
            for (int y = pos.y + 4; y > pos.y; --y) {
                if (this.field_145850_b.func_147439_a(pos.x, y, pos.z) != block) continue;
                this.blocksToHarvest.add(new BlockPosition(pos.x, y, pos.z));
            }
        } else if (block instanceof BlockCocoa) {
            if (!((IGrowable)block).func_149851_a(this.field_145850_b, pos.x, pos.y, pos.z, this.field_145850_b.field_72995_K)) {
                this.blocksToHarvest.add(pos.copy());
            } else {
                this.cocoaToGrow.add(pos.copy());
            }
        } else if (block instanceof BlockAir) {
            if (Blocks.field_150434_aF.func_149718_j(this.field_145850_b, pos.x, pos.y, pos.z)) {
                this.cactusToPlant.add(pos.copy());
            } else if (Blocks.field_150436_aH.func_149718_j(this.field_145850_b, pos.x, pos.y, pos.z)) {
                this.reedToPlant.add(pos.copy());
            } else if (this.isJungleLog(pos.x - 1, pos.y, pos.z) || this.isJungleLog(pos.x + 1, pos.y, pos.z) || this.isJungleLog(pos.x, pos.y, pos.z - 1) || this.isJungleLog(pos.x, pos.y, pos.z + 1)) {
                this.cocoaToPlant.add(pos.copy());
            }
        }
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.reedCount > 0 && !this.reedToPlant.isEmpty() || this.cactusCount > 0 && !this.cactusToPlant.isEmpty() || this.cocoaCount > 0 && !this.cocoaToPlant.isEmpty() || !this.blocksToHarvest.isEmpty() || this.bonemealCount > 0 && !this.cocoaToGrow.isEmpty();
    }
}

