/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import cpw.mods.fml.common.Loader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.api.IAncientWarfareFarmable;
import net.shadowmage.ancientwarfare.api.IAncientWarfarePlantable;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteUserBlocks;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteCropFarm
extends TileWorksiteUserBlocks {
    private final Set<BlockPosition> blocksToTill = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToHarvest = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToPlant = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToFertilize = new HashSet<BlockPosition>();
    private int plantableCount;
    private int bonemealCount;

    public WorkSiteCropFarm() {
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(27);
        int[] frontIndices = helper.getIndiceArrayForSpread(3);
        int[] bottomIndices = helper.getIndiceArrayForSpread(3);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.FRONT, frontIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.BOTTOM, bottomIndices);
        ItemSlotFilter filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteCropFarm.this.isPlantable(stack);
            }
        };
        this.inventory.setFilterForSlots(filter, frontIndices);
        filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteCropFarm.this.isBonemeal(stack);
            }
        };
        this.inventory.setFilterForSlots(filter, bottomIndices);
    }

    private boolean isPlantable(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IAncientWarfarePlantable) {
            return ((IAncientWarfarePlantable)item).isPlantable(stack);
        }
        return item instanceof IPlantable;
    }

    @Override
    protected boolean isFarmable(Block block, int x, int y, int z) {
        if (block instanceof IAncientWarfareFarmable && ((IAncientWarfareFarmable)block).isMature(this.field_145850_b, x, y, z)) {
            return true;
        }
        if (super.isFarmable(block, x, y, z)) {
            return ((IPlantable)block).getPlantType((IBlockAccess)this.field_145850_b, x, y, z) == EnumPlantType.Crop;
        }
        return block instanceof BlockCrops || block instanceof BlockStem;
    }

    private boolean isTillable(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d;
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.blocksToFertilize);
        this.validateCollection(this.blocksToHarvest);
        this.validateCollection(this.blocksToPlant);
        this.validateCollection(this.blocksToTill);
    }

    @Override
    protected void countResources() {
        this.plantableCount = 0;
        this.bonemealCount = 0;
        for (int i = 27; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (i < 30) {
                if (!this.isPlantable(stack)) continue;
                this.plantableCount += stack.field_77994_a;
                continue;
            }
            if (!this.isBonemeal(stack)) continue;
            this.bonemealCount += stack.field_77994_a;
        }
    }

    @Override
    protected int[] getIndicesForPickup() {
        return this.inventory.getRawIndicesCombined(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
    }

    @Override
    protected void scanBlockPosition(BlockPosition position) {
        Block block = this.field_145850_b.func_147439_a(position.x, position.y, position.z);
        if (block.isReplaceable((IBlockAccess)this.field_145850_b, position.x, position.y, position.z)) {
            block = this.field_145850_b.func_147439_a(position.x, position.y - 1, position.z);
            if (this.isTillable(block)) {
                this.blocksToTill.add(new BlockPosition(position.x, position.y - 1, position.z));
            } else if (block == Blocks.field_150458_ak) {
                this.blocksToPlant.add(position);
            }
        } else if (block instanceof BlockStem) {
            if (!((IGrowable)block).func_149851_a(this.field_145850_b, position.x, position.y, position.z, this.field_145850_b.field_72995_K)) {
                block = this.field_145850_b.func_147439_a(position.x - 1, position.y, position.z);
                if (this.melonOrPumpkin(block)) {
                    this.blocksToHarvest.add(new BlockPosition(position.x - 1, position.y, position.z));
                }
                if (this.melonOrPumpkin(block = this.field_145850_b.func_147439_a(position.x + 1, position.y, position.z))) {
                    this.blocksToHarvest.add(new BlockPosition(position.x + 1, position.y, position.z));
                }
                if (this.melonOrPumpkin(block = this.field_145850_b.func_147439_a(position.x, position.y, position.z - 1))) {
                    this.blocksToHarvest.add(new BlockPosition(position.x, position.y, position.z - 1));
                }
                if (this.melonOrPumpkin(block = this.field_145850_b.func_147439_a(position.x, position.y, position.z + 1))) {
                    this.blocksToHarvest.add(new BlockPosition(position.x, position.y, position.z + 1));
                }
            } else {
                this.blocksToFertilize.add(position);
            }
        } else if (block instanceof IGrowable && ((IGrowable)block).func_149851_a(this.field_145850_b, position.x, position.y, position.z, this.field_145850_b.field_72995_K)) {
            this.blocksToFertilize.add(position);
        } else if (this.isFarmable(block, position.x, position.y, position.z)) {
            this.blocksToHarvest.add(position);
        }
    }

    private boolean melonOrPumpkin(Block block) {
        return block.func_149688_o() == Material.field_151572_C;
    }

    @Override
    protected boolean processWork() {
        block24: {
            BlockPosition position;
            block26: {
                BlockPosition position2;
                block25: {
                    BlockPosition position3;
                    block23: {
                        BlockPosition position4;
                        if (this.blocksToTill.isEmpty()) break block23;
                        Iterator<BlockPosition> it = this.blocksToTill.iterator();
                        while (it.hasNext() && (position4 = it.next()) != null) {
                            it.remove();
                            Block block = this.field_145850_b.func_147439_a(position4.x, position4.y, position4.z);
                            if (!this.isTillable(block) || !this.canReplace(position4.x, position4.y + 1, position4.z)) continue;
                            this.field_145850_b.func_147449_b(position4.x, position4.y, position4.z, Blocks.field_150458_ak);
                            return true;
                        }
                        break block24;
                    }
                    if (this.blocksToHarvest.isEmpty()) break block25;
                    Iterator<BlockPosition> it = this.blocksToHarvest.iterator();
                    while (it.hasNext() && (position3 = it.next()) != null) {
                        it.remove();
                        Block block = this.field_145850_b.func_147439_a(position3.x, position3.y, position3.z);
                        if (this.melonOrPumpkin(block)) {
                            return this.harvestBlock(position3.x, position3.y, position3.z, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
                        }
                        if (block instanceof IGrowable) {
                            Class<?> c;
                            if (((IGrowable)block).func_149851_a(this.field_145850_b, position3.x, position3.y, position3.z, this.field_145850_b.field_72995_K) || block instanceof BlockStem) continue;
                            if (Loader.isModLoaded((String)"AgriCraft") && !(block instanceof IAncientWarfareFarmable) && "com.InfinityRaider.AgriCraft.blocks.BlockCrop".equals((c = block.getClass()).getName())) {
                                try {
                                    c.getDeclaredMethod("harvest", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, EntityPlayer.class).invoke((Object)block, this.field_145850_b, position3.x, position3.y, position3.z, null);
                                    return true;
                                }
                                catch (Throwable ignored) {
                                    return false;
                                }
                            }
                            return this.harvestBlock(position3.x, position3.y, position3.z, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
                        }
                        if (!this.isFarmable(block, position3.x, position3.y, position3.z)) continue;
                        return this.harvestBlock(position3.x, position3.y, position3.z, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
                    }
                    break block24;
                }
                if (!this.hasToPlant()) break block26;
                Iterator<BlockPosition> it = this.blocksToPlant.iterator();
                while (it.hasNext() && (position2 = it.next()) != null) {
                    it.remove();
                    if (!this.canReplace(position2.x, position2.y, position2.z)) continue;
                    for (int i = 27; i < 30; ++i) {
                        ItemStack stack = this.func_70301_a(i);
                        if (stack == null || !this.isPlantable(stack) || !this.tryPlace(stack, position2.x, position2.y, position2.z, ForgeDirection.UP)) continue;
                        --this.plantableCount;
                        if (stack.field_77994_a <= 0) {
                            this.func_70299_a(i, null);
                        }
                        return true;
                    }
                    return false;
                }
                break block24;
            }
            if (!this.hasToFertilize()) break block24;
            Iterator<BlockPosition> it = this.blocksToFertilize.iterator();
            while (it.hasNext() && (position = it.next()) != null) {
                it.remove();
                Block block = this.field_145850_b.func_147439_a(position.x, position.y, position.z);
                if (!(block instanceof IGrowable)) continue;
                for (int i = 30; i < this.func_70302_i_(); ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack == null || !this.isBonemeal(stack)) continue;
                    if (ItemDye.applyBonemeal((ItemStack)stack, (World)this.field_145850_b, (int)position.x, (int)position.y, (int)position.z, (EntityPlayer)this.getOwnerAsPlayer())) {
                        --this.bonemealCount;
                        if (stack.field_77994_a <= 0) {
                            this.func_70299_a(i, null);
                        }
                    }
                    if ((block = this.field_145850_b.func_147439_a(position.x, position.y, position.z)) instanceof IAncientWarfareFarmable) {
                        IAncientWarfareFarmable farmable = (IAncientWarfareFarmable)block;
                        if (farmable.isMature(this.field_145850_b, position.x, position.y, position.z)) {
                            this.blocksToHarvest.add(position);
                        } else if (farmable.func_149851_a(this.field_145850_b, position.x, position.y, position.z, this.field_145850_b.field_72995_K)) {
                            this.blocksToFertilize.add(position);
                        }
                    } else if (block instanceof IGrowable) {
                        if (((IGrowable)block).func_149851_a(this.field_145850_b, position.x, position.y, position.z, this.field_145850_b.field_72995_K)) {
                            this.blocksToFertilize.add(position);
                        } else if (this.isFarmable(block, position.x, position.y, position.z)) {
                            this.blocksToHarvest.add(position);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 27, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.hasToPlant() || this.hasToFertilize() || !this.blocksToTill.isEmpty() || !this.blocksToHarvest.isEmpty();
    }

    private boolean hasToPlant() {
        return this.plantableCount > 0 && !this.blocksToPlant.isEmpty();
    }

    private boolean hasToFertilize() {
        return this.bonemealCount > 0 && !this.blocksToFertilize.isEmpty();
    }
}

