/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import com.google.common.base.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public final class WarehouseInterfaceFilter
implements Predicate<ItemStack>,
INBTSerialable {
    private ItemStack filterItem;
    private int quantity;

    public boolean apply(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.filterItem == null) {
            return false;
        }
        if (item.func_77973_b() != this.filterItem.func_77973_b()) {
            return false;
        }
        return InventoryTools.doItemStacksMatch(this.filterItem, item);
    }

    public boolean equals(Object object) {
        return object instanceof WarehouseInterfaceFilter && ((WarehouseInterfaceFilter)object).quantity == this.quantity && this.apply(((WarehouseInterfaceFilter)object).filterItem);
    }

    public int hashCode() {
        int result = this.getFilterItem() != null ? new ItemQuantityMap.ItemHashEntry(this.getFilterItem()).hashCode() : 0;
        return 31 * result + this.quantity;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.quantity = tag.func_74762_e("quantity");
        if (tag.func_74764_b("filter")) {
            this.filterItem = InventoryTools.readItemStack(tag.func_74775_l("filter"));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("quantity", this.quantity);
        if (this.filterItem != null) {
            tag.func_74782_a("filter", (NBTBase)InventoryTools.writeItemStack(this.filterItem));
        }
        return tag;
    }

    public final ItemStack getFilterItem() {
        return this.filterItem;
    }

    public final void setFilterItem(ItemStack item) {
        this.filterItem = item;
    }

    public final int getFilterQuantity() {
        return this.quantity;
    }

    public final void setFilterQuantity(int filterQuantity) {
        this.quantity = filterQuantity;
    }

    public String toString() {
        return "Filter item: " + this.filterItem + " quantity: " + this.quantity;
    }

    public WarehouseInterfaceFilter copy() {
        WarehouseInterfaceFilter filter = new WarehouseInterfaceFilter();
        if (this.filterItem != null) {
            filter.setFilterItem(this.filterItem.func_77946_l());
        }
        filter.setFilterQuantity(this.quantity);
        return filter;
    }
}

