/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.inventory.InventorySlotlessBasic;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileWarehouseStorage
extends TileControlled
implements IWarehouseStorageTile,
IInteractableTile {
    private InventorySlotlessBasic inventory;
    private final List<WarehouseStorageFilter> filters = new ArrayList<WarehouseStorageFilter>();
    private final Set<ContainerWarehouseStorage> viewers = new HashSet<ContainerWarehouseStorage>();

    public TileWarehouseStorage() {
        this.inventory = new InventorySlotlessBasic(this.getStorageAdditionSize());
    }

    @Override
    public ItemStack tryAdd(ItemStack cursorStack) {
        int moved = this.insertItem(cursorStack, cursorStack.field_77994_a);
        cursorStack.field_77994_a -= moved;
        TileWarehouseBase twb = (TileWarehouseBase)this.getController();
        if (twb != null) {
            twb.changeCachedQuantity(cursorStack, moved);
        }
        if (cursorStack.field_77994_a <= 0) {
            return null;
        }
        return cursorStack;
    }

    @Override
    protected void updateTile() {
    }

    public void onTileBroken() {
        ItemQuantityMap qtm = new ItemQuantityMap();
        this.addItems(qtm);
        if (this.getController() != null) {
            this.getController().removeControlledTile(this);
        }
        List<ItemStack> list = qtm.getItems();
        for (ItemStack stack : list) {
            InventoryTools.dropItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int getStorageAdditionSize() {
        return 576;
    }

    @Override
    public void onWarehouseInventoryUpdated(TileWarehouseBase warehouse) {
    }

    @Override
    public List<WarehouseStorageFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<WarehouseStorageFilter> filters) {
        ArrayList<WarehouseStorageFilter> old = new ArrayList<WarehouseStorageFilter>();
        old.addAll(this.filters);
        this.filters.clear();
        this.filters.addAll(filters);
        if (this.getController() != null) {
            ((TileWarehouseBase)this.getController()).onStorageFilterChanged(this, old, this.filters);
        }
        this.updateViewers();
        this.func_70296_d();
    }

    @Override
    public void addItems(ItemQuantityMap map) {
        this.inventory.getItems(map);
    }

    @Override
    public int getQuantityStored(ItemStack filter) {
        return this.inventory.getQuantityStored(filter);
    }

    @Override
    public int getAvailableSpaceFor(ItemStack filter) {
        return this.inventory.getAvailableSpaceFor(filter);
    }

    @Override
    public int extractItem(ItemStack filter, int amount) {
        int removed = this.inventory.extractItem(filter, amount);
        this.updateViewersForInventory();
        return removed;
    }

    @Override
    public int insertItem(ItemStack filter, int amount) {
        int inserted = this.inventory.insertItem(filter, amount);
        this.updateViewersForInventory();
        return inserted;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        this.filters.addAll(INBTSerialable.Helper.read(tag, "filterList", WarehouseStorageFilter.class));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        INBTSerialable.Helper.write(tag, "filterList", this.filters);
    }

    @Override
    public void addViewer(ContainerWarehouseStorage containerWarehouseStorage) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(containerWarehouseStorage);
    }

    @Override
    public void removeViewer(ContainerWarehouseStorage containerWarehouseStorage) {
        this.viewers.remove((Object)containerWarehouseStorage);
    }

    protected void updateViewers() {
        for (ContainerWarehouseStorage viewer : this.viewers) {
            viewer.onFilterListUpdated();
        }
    }

    protected void updateViewersForInventory() {
        for (ContainerWarehouseStorage viewer : this.viewers) {
            viewer.onStorageInventoryUpdated();
        }
        this.func_70296_d();
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 19, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void handleSlotClick(EntityPlayer player, ItemStack filter, boolean shiftClick) {
        if (filter != null && player.field_71071_by.func_70445_o() == null) {
            this.tryGetItem(player, filter, shiftClick);
        } else if (player.field_71071_by.func_70445_o() != null) {
            this.tryAddItem(player, player.field_71071_by.func_70445_o());
        }
    }

    private void tryAddItem(EntityPlayer player, ItemStack cursorStack) {
        int stackSize = cursorStack.field_77994_a;
        int moved = this.insertItem(cursorStack, cursorStack.field_77994_a);
        cursorStack.field_77994_a -= moved;
        TileWarehouseBase twb = (TileWarehouseBase)this.getController();
        if (twb != null) {
            twb.changeCachedQuantity(cursorStack, moved);
        }
        if (cursorStack.field_77994_a <= 0) {
            player.field_71071_by.func_70437_b(null);
        }
        if (stackSize != cursorStack.field_77994_a) {
            ((EntityPlayerMP)player).func_71113_k();
        }
    }

    private void tryGetItem(EntityPlayer player, ItemStack filter, boolean shiftClick) {
        ItemStack newCursorStack = filter.func_77946_l();
        newCursorStack.field_77994_a = 0;
        int count = this.getQuantityStored(filter);
        int toMove = newCursorStack.func_77976_d() - newCursorStack.field_77994_a;
        int n = toMove = toMove > count ? count : toMove;
        if (toMove > 0) {
            newCursorStack.field_77994_a += toMove;
            this.extractItem(filter, toMove);
            TileWarehouseBase twb = (TileWarehouseBase)this.getController();
            if (twb != null) {
                twb.changeCachedQuantity(filter, -toMove);
            }
        }
        InventoryTools.updateCursorItem((EntityPlayerMP)player, newCursorStack, shiftClick);
    }
}

