/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseInterface;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseInterfaceFilter;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.inventory.InventoryBasic;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileWarehouseInterface
extends TileControlled
implements IInventory,
IInteractableTile {
    final InventoryBasic inventory = new InventoryBasic(27);
    private boolean init = false;
    private final List<InterfaceFillRequest> fillRequests = new ArrayList<InterfaceFillRequest>();
    private final List<InterfaceEmptyRequest> emptyRequests = new ArrayList<InterfaceEmptyRequest>();
    List<WarehouseInterfaceFilter> filters = new ArrayList<WarehouseInterfaceFilter>();
    List<ContainerWarehouseInterface> viewers = new ArrayList<ContainerWarehouseInterface>();

    public void addViewer(ContainerWarehouseInterface viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerWarehouseInterface viewer) {
        this.viewers.remove((Object)viewer);
    }

    public void updateViewers() {
        for (ContainerWarehouseInterface v : this.viewers) {
            v.onInterfaceFiltersChanged();
        }
    }

    public List<WarehouseInterfaceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WarehouseInterfaceFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
        this.recalcRequests();
        this.updateViewers();
        this.func_70296_d();
    }

    @Override
    protected void updateTile() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.init) {
            this.init = true;
            this.recalcRequests();
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack stack = this.inventory.func_70298_a(var1, var2);
        if (stack != null) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int var1) {
        ItemStack stack = this.inventory.func_70304_b(var1);
        this.recalcRequests();
        return stack;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
        this.recalcRequests();
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.inventory.func_70300_a(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.inventory.func_94041_b(var1, var2);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 21, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        this.filters = INBTSerialable.Helper.read(tag, "filterList", WarehouseInterfaceFilter.class);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        INBTSerialable.Helper.write(tag, "filterList", this.getFilters());
    }

    public void recalcRequests() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.fillRequests.clear();
        this.emptyRequests.clear();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            int max;
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null) continue;
            if (!this.matchesFilter(stack)) {
                this.emptyRequests.add(new InterfaceEmptyRequest(i, stack.field_77994_a));
                continue;
            }
            int count = InventoryTools.getCountOf((IInventory)this.inventory, -1, stack);
            if (count <= (max = this.getFilterQuantity(stack))) continue;
            this.emptyRequests.add(new InterfaceEmptyRequest(i, count - max));
        }
        for (WarehouseInterfaceFilter filter : this.filters) {
            int count;
            if (filter.getFilterItem() == null || (count = InventoryTools.getCountOf((IInventory)this.inventory, -1, filter.getFilterItem())) >= filter.getFilterQuantity()) continue;
            this.fillRequests.add(new InterfaceFillRequest(filter.getFilterItem().func_77946_l(), filter.getFilterQuantity() - count));
        }
        TileWarehouseBase twb = (TileWarehouseBase)this.getController();
        if (twb != null) {
            twb.onIterfaceInventoryChanged(this);
        }
    }

    protected boolean matchesFilter(ItemStack stack) {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (WarehouseInterfaceFilter filter : this.filters) {
            if (!filter.apply(stack)) continue;
            return true;
        }
        return false;
    }

    protected int getFilterQuantity(ItemStack stack) {
        int qty = 0;
        for (WarehouseInterfaceFilter filter : this.filters) {
            if (!filter.apply(stack)) continue;
            qty += filter.getFilterQuantity();
        }
        return qty;
    }

    public List<InterfaceFillRequest> getFillRequests() {
        return this.fillRequests;
    }

    public List<InterfaceEmptyRequest> getEmptyRequests() {
        return this.emptyRequests;
    }

    public static class InterfaceEmptyRequest {
        final int slotNum;
        final int count;

        public InterfaceEmptyRequest(int slot, int count) {
            this.slotNum = slot;
            this.count = count;
        }
    }

    public static class InterfaceFillRequest {
        final ItemStack requestedItem;
        final int requestAmount;

        public InterfaceFillRequest(ItemStack item, int amount) {
            this.requestedItem = item;
            this.requestAmount = amount;
        }
    }
}

