/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.proxy.RFProxy;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBlockEvent;

@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore", striprefs=true)
public abstract class TileTorqueBase
extends TileEntity
implements ITorque.ITorqueTile,
IInteractableTile,
BlockRotationHandler.IRotatableTile,
IEnergyHandler {
    public static final int DIRECTION_LENGTH = ForgeDirection.VALID_DIRECTIONS.length;
    protected ForgeDirection orientation = ForgeDirection.NORTH;
    protected int networkUpdateTicks;
    private TileEntity[] rfCache;
    private ITorque.ITorqueTile[] torqueCache;
    protected double torqueIn;
    protected double torqueOut;
    protected double torqueLoss;
    protected double prevEnergy;

    @Optional.Method(modid="CoFHCore")
    public final int getEnergyStored(ForgeDirection from) {
        return (int)(this.getTorqueStored(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="CoFHCore")
    public final int getMaxEnergyStored(ForgeDirection from) {
        return (int)(this.getMaxTorque(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="CoFHCore")
    public final boolean canConnectEnergy(ForgeDirection from) {
        return this.canOutputTorque(from) || this.canInputTorque(from);
    }

    @Optional.Method(modid="CoFHCore")
    public final int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public final int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canInputTorque(from)) {
            return 0;
        }
        if (simulate) {
            return Math.min(maxReceive, (int)(AWAutomationStatics.torqueToRf * this.getMaxTorqueInput(from)));
        }
        return (int)(AWAutomationStatics.torqueToRf * this.addTorque(from, (double)maxReceive * AWAutomationStatics.rfToTorque));
    }

    public final ITorque.ITorqueTile[] getTorqueCache() {
        if (this.torqueCache == null) {
            this.buildTorqueCache();
        }
        return this.torqueCache;
    }

    public final TileEntity[] getRFCache() {
        if (this.rfCache == null) {
            this.buildRFCache();
        }
        return this.rfCache;
    }

    private void buildTorqueCache() {
        if (!this.func_145830_o()) {
            throw new RuntimeException("Attempt to build neighbor cache on null world!!");
        }
        ITorque.ITorqueTile[] torqueCache = new ITorque.ITorqueTile[DIRECTION_LENGTH];
        for (int i = 0; i < torqueCache.length; ++i) {
            TileEntity te;
            int z;
            int y;
            int x;
            ForgeDirection dir = ForgeDirection.values()[i];
            if (!this.canOutputTorque(dir) && !this.canInputTorque(dir) || !this.field_145850_b.func_72899_e(x = this.field_145851_c + dir.offsetX, y = this.field_145848_d + dir.offsetY, z = this.field_145849_e + dir.offsetZ) || !((te = this.field_145850_b.func_147438_o(x, y, z)) instanceof ITorque.ITorqueTile)) continue;
            torqueCache[i] = (ITorque.ITorqueTile)te;
        }
        this.torqueCache = torqueCache;
    }

    private void buildRFCache() {
        TileEntity[] rfCache = new TileEntity[DIRECTION_LENGTH];
        for (int i = 0; i < rfCache.length; ++i) {
            TileEntity te;
            int z;
            int y;
            int x;
            ForgeDirection dir = ForgeDirection.values()[i];
            if (!this.canOutputTorque(dir) && !this.canInputTorque(dir) || !this.field_145850_b.func_72899_e(x = this.field_145851_c + dir.offsetX, y = this.field_145848_d + dir.offsetY, z = this.field_145849_e + dir.offsetZ) || !RFProxy.instance.isRFTile(te = this.field_145850_b.func_147438_o(x, y, z))) continue;
            rfCache[dir.ordinal()] = te;
        }
        this.rfCache = rfCache;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.invalidateNeighborCache();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateNeighborCache();
    }

    public void onNeighborTileChanged() {
        this.invalidateNeighborCache();
    }

    protected final void invalidateNeighborCache() {
        this.torqueCache = null;
        this.rfCache = null;
        this.onNeighborCacheInvalidated();
    }

    protected void onNeighborCacheInvalidated() {
    }

    @Override
    public final void setPrimaryFacing(ForgeDirection d) {
        this.orientation = d;
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.invalidateNeighborCache();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public final ForgeDirection getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.automation.torque.values", new Object[]{String.format("%.2f", this.getTotalTorque()), String.format("%.2f", this.getTorqueIn()), String.format("%.2f", this.getTorqueOut()), String.format("%.2f", this.getTorqueLoss())}));
            }
            return true;
        }
        return false;
    }

    protected void updateRotation() {
        throw new UnsupportedOperationException();
    }

    protected void clientNetworkUpdate() {
        throw new UnsupportedOperationException();
    }

    protected void serverNetworkSynch() {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleClientRotationData(ForgeDirection var1, int var2);

    protected abstract double getTotalTorque();

    protected double getTorqueOut() {
        return this.torqueOut;
    }

    protected double getTorqueIn() {
        return this.torqueIn;
    }

    protected double getTorqueLoss() {
        return this.torqueLoss;
    }

    protected final void serverNetworkUpdate() {
        --this.networkUpdateTicks;
        if (this.networkUpdateTicks <= 0) {
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
            this.serverNetworkSynch();
        }
    }

    protected void sendSideRotation(ForgeDirection side, int value) {
        int valueBits = value & 0xFF;
        this.sendDataToClient(side.ordinal(), valueBits);
    }

    protected final double transferPowerTo(ForgeDirection from) {
        double transferred = 0.0;
        ITorque.ITorqueTile[] tc = this.getTorqueCache();
        if (tc[from.ordinal()] != null) {
            if (tc[from.ordinal()].canInputTorque(from.getOpposite())) {
                return this.drainTorque(from, tc[from.ordinal()].addTorque(from.getOpposite(), this.getMaxTorqueOutput(from)));
            }
        } else if (ModuleStatus.redstoneFluxEnabled && (transferred = RFProxy.instance.transferPower(this, from, this.getRFCache()[from.ordinal()])) > 0.0) {
            return transferred;
        }
        return transferred;
    }

    protected final double applyPowerDrain(ITorque.TorqueCell cell) {
        double e = cell.getEnergy();
        cell.setEnergy(e * cell.getEfficiency());
        return cell.getEnergy() - e;
    }

    protected final void sendDataToClient(int type, int data) {
        PacketBlockEvent pkt = new PacketBlockEvent();
        pkt.setParams(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), (short)type, (short)data);
        NetworkHandler.sendToAllTrackingChunk(this.field_145850_b, this.field_145851_c >> 4, this.field_145849_e >> 4, pkt);
    }

    protected final float getRotation(double rotation, double prevRotation, float delta) {
        double rd = rotation - prevRotation;
        return (float)(prevRotation + rd * (double)delta);
    }

    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a < DIRECTION_LENGTH) {
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
            this.handleClientRotationData(ForgeDirection.values()[a], b);
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.orientation = ForgeDirection.getOrientation((int)tag.func_74762_e("orientation"));
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("orientation", this.orientation.ordinal());
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = this.getDescriptionTag();
        if (tag == null) {
            return null;
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("orientation", this.orientation.ordinal());
        return tag;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.orientation = ForgeDirection.getOrientation((int)pkt.func_148857_g().func_74762_e("orientation"));
        this.invalidateNeighborCache();
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

