/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileDistributor
extends TileTorqueSidedCell {
    @Override
    protected double transferPower() {
        int in = this.getPrimaryFacing().getOpposite().ordinal();
        double out = 0.0;
        for (int i = 0; i < DIRECTION_LENGTH; ++i) {
            if (i == in) continue;
            out += this.transferPowerTo(ForgeDirection.values()[i]);
        }
        return out;
    }

    @Override
    protected void balanceStorage() {
        ITorque.SidedTorqueCell out;
        int in = this.getPrimaryFacing().getOpposite().ordinal();
        ITorque.SidedTorqueCell input = this.storage[in];
        double totalRequested = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            if (i == in) continue;
            out = this.storage[i];
            if (!this.getConnections()[i]) continue;
            totalRequested += out.getMaxEnergy() - out.getEnergy();
        }
        if (totalRequested > 0.0 && input.getEnergy() > 0.0) {
            double transfer = Math.min(totalRequested, input.getEnergy());
            double percent = transfer / totalRequested;
            double transferred = 0.0;
            for (int i = 0; i < this.storage.length; ++i) {
                if (i == in || !this.getConnections()[i]) continue;
                out = this.storage[i];
                double request = out.getMaxEnergy() - out.getEnergy();
                double trans = request * percent;
                transferred += trans;
                out.setEnergy(out.getEnergy() + trans);
            }
            input.setEnergy(input.getEnergy() - transferred);
        }
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return from == this.orientation.getOpposite();
    }

    @Override
    public boolean canOutputTorque(ForgeDirection from) {
        return from != this.orientation.getOpposite();
    }
}

