/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.IconRotationMap;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class BlockTorqueBase
extends Block
implements BlockRotationHandler.IRotatableBlock {
    HashMap<Integer, IconRotationMap> iconMaps = new HashMap();

    protected BlockTorqueBase(Material material) {
        super(material);
        this.func_149711_c(2.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInteractableTile && ((IInteractableTile)te).onBlockClicked(player);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (IconRotationMap map : this.iconMaps.values()) {
            map.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        IconRotationMap icr;
        ForgeDirection d;
        BlockRotationHandler.IRotatableTile tt = (BlockRotationHandler.IRotatableTile)block.func_147438_o(x, y, z);
        int meta = 2;
        if (tt != null && (d = tt.getPrimaryFacing()) != null) {
            meta = d.ordinal();
        }
        if ((icr = this.iconMaps.get(meta)) != null) {
            return icr.getIcon(this, meta, side);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        IconRotationMap icr = this.iconMaps.get(meta);
        if (icr != null) {
            return icr.getIcon(this, meta, side);
        }
        return null;
    }

    @Override
    public BlockTorqueBase setIcon(BlockRotationHandler.RelativeSide side, String texName) {
        throw new UnsupportedOperationException("Cannot set side icons directly on torque block, need to use meta-sensitive version");
    }

    public BlockTorqueBase setIcon(int meta, BlockRotationHandler.RelativeSide side, String texName) {
        if (!this.iconMaps.containsKey(meta)) {
            this.iconMaps.put(meta, new IconRotationMap());
        }
        this.iconMaps.get(meta).setIcon(this, side, texName);
        return this;
    }

    public IIcon getIcon(int meta, BlockRotationHandler.RelativeSide side) {
        return this.iconMaps.get(meta).getIcon(side);
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTorqueBase) {
            ((TileTorqueBase)te).onNeighborTileChanged();
        }
        super.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTorqueBase) {
            ((TileTorqueBase)te).onNeighborTileChanged();
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        BlockRotationHandler.IRotatableTile tt = (BlockRotationHandler.IRotatableTile)worldObj.func_147438_o(x, y, z);
        int meta = tt.getPrimaryFacing().ordinal();
        int rMeta = BlockRotationHandler.getRotatedMeta(this, meta, axis);
        if (rMeta != meta) {
            tt.setPrimaryFacing(ForgeDirection.getOrientation((int)rMeta));
            worldObj.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int a, int b) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(a, b);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            InventoryTools.dropInventoryInWorld(world, (IInventory)te, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149692_a(int meta) {
        return meta;
    }
}

