/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.synthesis;

import java.util.ArrayList;
import java.util.Arrays;
import minechem.potion.PotionChemical;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.utils.Compare;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class SynthesisRecipeHandler {
    public static SynthesisRecipeHandler instance = new SynthesisRecipeHandler();

    public SynthesisRecipe getRecipeFromOutput(ItemStack output) {
        MapKey key = MapKey.getKey(output);
        if (key == null) {
            return null;
        }
        return SynthesisRecipe.recipes.get(key);
    }

    public SynthesisRecipe getRecipeFromInput(ItemStack[] input) {
        for (SynthesisRecipe recipe : SynthesisRecipe.recipes.values()) {
            if (!this.itemStacksMatchesRecipe(input, recipe)) continue;
            return recipe;
        }
        return null;
    }

    public boolean itemStacksMatchesRecipe(ItemStack[] stacks, SynthesisRecipe recipe) {
        return this.itemStacksMatchesRecipe(stacks, recipe, 1);
    }

    public boolean itemStacksMatchesRecipe(ItemStack[] stacks, SynthesisRecipe recipe, int factor) {
        if (recipe.isShaped()) {
            return this.itemStacksMatchesShapedRecipe(stacks, recipe, factor);
        }
        return this.itemStacksMatchesShapelessRecipe(stacks, recipe, factor);
    }

    private boolean itemStacksMatchesShapelessRecipe(ItemStack[] stacks, SynthesisRecipe recipe, int factor) {
        ArrayList<ItemStack> stacksList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> shapelessRecipe = MinechemUtil.convertChemicalsIntoItemStacks(new ArrayList<PotionChemical>(Arrays.asList(recipe.getShapelessRecipe())));
        for (ItemStack itemstack : stacks) {
            if (itemstack == null) continue;
            stacksList.add(itemstack.func_77946_l());
        }
        for (ItemStack itemstack : stacksList) {
            int ingredientSlot = this.getIngredientSlotThatMatchesStack(shapelessRecipe, itemstack, 1);
            if (ingredientSlot != -1) {
                shapelessRecipe.remove(ingredientSlot);
                continue;
            }
            return false;
        }
        return shapelessRecipe.size() == 0;
    }

    private boolean itemStacksMatchesShapedRecipe(ItemStack[] stacks, SynthesisRecipe recipe, int factor) {
        PotionChemical[] chemicals = recipe.getShapedRecipe();
        for (int i = 0; i < chemicals.length; ++i) {
            if (stacks[i] == null && chemicals[i] == null) continue;
            if (stacks[i] == null || chemicals[i] == null) {
                return false;
            }
            if (MinechemUtil.itemStackMatchesChemical(stacks[i], chemicals[i], factor) && stacks[i].field_77994_a == chemicals[i].amount) continue;
            return false;
        }
        return true;
    }

    private int getIngredientSlotThatMatchesStack(ArrayList<ItemStack> ingredients, ItemStack itemstack, int factor) {
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            ItemStack ingredientStack = ingredients.get(slot);
            if (ingredientStack == null || !Compare.stacksAreSameKind(itemstack, ingredientStack) || itemstack.field_77994_a != ingredientStack.field_77994_a) continue;
            return slot;
        }
        return -1;
    }

    public static boolean takeFromCraftingInventory(SynthesisRecipe recipe, IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            inv.func_70299_a(slot, null);
        }
        return true;
    }
}

