/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock.fission;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.item.blueprint.BlueprintFission;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.network.MessageHandler;
import minechem.network.message.FissionUpdateMessage;
import minechem.tileentity.multiblock.MultiBlockTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FissionTileEntity
extends MultiBlockTileEntity
implements ISidedInventory {
    public static int[] kInput = new int[]{0};
    public static int[] kOutput = new int[]{2};
    public static int kStartInput = 0;

    public FissionTileEntity() {
        super(Settings.maxFissionStorage);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.setBlueprint(new BlueprintFission());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.completeStructure) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.inventory[kStartInput] != null && this.inputIsFissionable() && this.useEnergy(this.getEnergyNeeded())) {
                ItemStack fissionResult = this.getFissionOutput();
                this.addToOutput(fissionResult);
                this.removeInputs();
            }
            FissionUpdateMessage message = new FissionUpdateMessage(this);
            MessageHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)Settings.UpdateRadius));
        }
    }

    public boolean inputIsFissionable() {
        ItemStack fissionResult = this.getFissionOutput();
        if (fissionResult != null) {
            if (this.inventory[kOutput[0]] == null) {
                return true;
            }
            boolean sameItem = fissionResult.func_77973_b() == this.inventory[kOutput[0]].func_77973_b() && fissionResult.func_77960_j() == this.inventory[kOutput[0]].func_77960_j();
            return this.inventory[FissionTileEntity.kOutput[0]].field_77994_a < 64 && sameItem;
        }
        return false;
    }

    private void addToOutput(ItemStack fusionResult) {
        if (fusionResult == null) {
            return;
        }
        if (this.inventory[kOutput[0]] == null) {
            ItemStack output;
            this.inventory[FissionTileEntity.kOutput[0]] = output = fusionResult.func_77946_l();
        } else {
            this.inventory[FissionTileEntity.kOutput[0]].field_77994_a += 2;
        }
    }

    private void removeInputs() {
        this.func_70298_a(kInput[0], 1);
    }

    private ItemStack getFissionOutput() {
        if (this.inventory[kInput[0]] != null && this.inventory[kInput[0]].func_77973_b() instanceof ElementItem && this.inventory[kInput[0]].func_77960_j() > 0) {
            int mass = ElementItem.getElement(this.inventory[kInput[0]]).atomicNumber();
            int newMass = mass / 2;
            if (newMass > 0 && ElementEnum.getByID(newMass) != null) {
                return new ItemStack((Item)MinechemItemsRegistration.element, 2, newMass);
            }
            return null;
        }
        return null;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
    }

    public String func_145825_b() {
        return "container.minechemFission";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.completeStructure;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackArrayToTagList(this.inventory);
        nbtTagCompound.func_74782_a("inventory", (NBTBase)inventoryTagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory = new ItemStack[this.func_70302_i_()];
        MinechemUtil.readTagListToItemStackArray(nbtTagCompound.func_150295_c("inventory", 10), this.inventory);
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot != 2 && itemstack.func_77973_b() instanceof ElementItem) {
            if (slot == 1 && itemstack.func_77960_j() == 91) {
                return true;
            }
            if (slot == 0) {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int i) {
        switch (i) {
            case 0: {
                return kOutput;
            }
        }
        return kInput;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int i2) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int i2) {
        return false;
    }

    @Override
    public int getEnergyNeeded() {
        if (this.inventory[0] != null) {
            return this.inventory[0].func_77960_j() * Settings.fissionMultiplier;
        }
        return 0;
    }
}

