/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import minechem.tileentity.decomposer.DecomposerFluidRecipe;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeSuper;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import minechem.utils.Recipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DecomposerRecipeHandler {
    public static DecomposerRecipeHandler instance = new DecomposerRecipeHandler();

    private DecomposerRecipeHandler() {
    }

    public static void recursiveRecipes() {
        for (MapKey key : Recipe.recipes.keySet()) {
            if (DecomposerRecipe.recipes.containsKey(key)) continue;
            Recipe recipe = Recipe.get(key);
            DecomposerRecipe.add(new DecomposerRecipeSuper(recipe.output, recipe.inStacks));
        }
        Iterator<Map.Entry<MapKey, DecomposerRecipe>> itr = DecomposerRecipe.recipes.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<MapKey, DecomposerRecipe> entry = itr.next();
            if (!entry.getValue().isNull()) continue;
            itr.remove();
        }
    }

    public static void resetRecursiveRecipes() {
        for (MapKey key : DecomposerRecipe.recipes.keySet()) {
            if (!(DecomposerRecipe.get(key) instanceof DecomposerRecipeSuper)) continue;
            DecomposerRecipe.remove(key);
        }
        Recipe.init();
        DecomposerRecipeHandler.recursiveRecipes();
    }

    public DecomposerRecipe getRecipe(ItemStack input) {
        return DecomposerRecipe.get(input);
    }

    public DecomposerRecipe getRecipe(FluidStack fluidStack) {
        return DecomposerRecipe.get(fluidStack);
    }

    public ArrayList<ItemStack> getRecipeOutputForInput(ItemStack input) {
        DecomposerRecipe recipe = this.getRecipe(input);
        if (recipe != null) {
            return MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutput());
        }
        return null;
    }

    public ArrayList<ItemStack> getRecipeOutputForFluidInput(FluidStack input) {
        DecomposerFluidRecipe fluidRecipe = (DecomposerFluidRecipe)DecomposerRecipe.get(input);
        if (fluidRecipe != null) {
            return MinechemUtil.convertChemicalsIntoItemStacks(fluidRecipe.getOutput());
        }
        return null;
    }
}

