/*
 * Decompiled with CFR 0.152.
 */
package minechem.radiation;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import minechem.api.IRadiationShield;
import minechem.gui.CreativeTabMinechem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class RadiationItemArmorShield
extends ItemArmor
implements IRadiationShield {
    private float radiationShieldFactor;
    private String textureFile;

    public RadiationItemArmorShield(int id, int part, float radiationShieldFactor, String texture) {
        super(ItemArmor.ArmorMaterial.CHAIN, 2, part);
        this.radiationShieldFactor = radiationShieldFactor;
        this.func_77655_b("itemArmorRadiationShield");
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_ITEMS);
        this.textureFile = texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a(this.textureFile);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        int percentile = (int)(this.radiationShieldFactor * 100.0f);
        String info = String.format("%d%% Radiation Shielding", percentile);
        list.add(info);
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        itemstack.func_77972_a(baseDamage / 4, (EntityLivingBase)player);
        return this.radiationShieldFactor;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "textures/model/hazmatArmor.png";
    }
}

