/*
 * Decompiled with CFR 0.152.
 */
package minechem.oredictionary;

import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.oredictionary.OreDictionaryHandler;
import minechem.tileentity.decomposer.DecomposerRecipe;

public class OreDictionaryMineFactoryReloadedHandler
implements OreDictionaryHandler {
    @Override
    public boolean canHandle(String oreName) {
        return oreName.equals("itemRawRubber") || oreName.equals("itemRubber") || oreName.equals("fertilizerOrganic");
    }

    @Override
    public void handle(String oreName) {
        if (oreName.equals("itemRawRubber")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, new Molecule(MoleculeEnum.cellulose, 3), new Molecule(MoleculeEnum.polyisobutylene, 1));
        } else if (oreName.equals("itemRubber")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, new Molecule(MoleculeEnum.cellulose, 1), new Molecule(MoleculeEnum.polyisobutylene, 3));
        } else if (oreName.equals("fertilizerOrganic")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, new Element(ElementEnum.C, 1), new Element(ElementEnum.O, 1), new Element(ElementEnum.N, 2), new Element(ElementEnum.H, 2));
        } else if (oreName.equals("rawPlastic")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, new Molecule(MoleculeEnum.vinylChloride, 1));
        } else if (oreName.equals("sheetPlastic")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, new Molecule(MoleculeEnum.vinylChloride, 2));
        }
    }
}

