/*
 * Decompiled with CFR 0.152.
 */
package minechem.minetweaker;

import java.util.ArrayList;
import java.util.Arrays;
import minechem.potion.PotionChemical;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisRecipeHandler;
import minechem.utils.InputHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.minechem.Synthesiser")
public class Synthesiser {
    @ZenMethod
    public static void addRecipe(IIngredient[] inputs, IIngredient outputStack, boolean shaped, int energy) {
        ItemStack output;
        boolean someValue = false;
        PotionChemical[] inputFixed = new PotionChemical[9];
        if (shaped) {
            for (int i = 0; i < inputFixed.length && i < inputs.length; ++i) {
                if (inputs[i] == null) continue;
                inputFixed[i] = InputHelper.getChemical(inputs[i]);
                if (inputFixed[i] == null) continue;
                someValue = true;
            }
        } else {
            ArrayList<PotionChemical> input = InputHelper.getChemicals(inputs);
            inputFixed = Arrays.copyOf(input.toArray(new PotionChemical[0]), 9);
            boolean bl = someValue = !input.isEmpty();
        }
        if (someValue && (output = InputHelper.getInput(outputStack)) != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, shaped, energy, inputFixed));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        ArrayList<ItemStack> toRemove = InputHelper.getInputs(input);
        for (ItemStack remove : toRemove) {
            SynthesisRecipe recipe = SynthesisRecipeHandler.instance.getRecipeFromOutput(remove);
            if (recipe == null) continue;
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(recipe));
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final SynthesisRecipe recipe;

        public RemoveRecipeAction(SynthesisRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            SynthesisRecipe.remove(this.recipe.getOutput());
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SynthesisRecipe.add(this.recipe);
        }

        public String describe() {
            return "Removing synthesis recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public String describeUndo() {
            return "Restoring synthesis recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final SynthesisRecipe recipe;

        public AddRecipeAction(ItemStack output, boolean shaped, int energy, PotionChemical[] input) {
            this.recipe = new SynthesisRecipe(output, shaped, energy, input);
        }

        public void apply() {
            SynthesisRecipe.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SynthesisRecipe.remove(this.recipe.getOutput());
        }

        public String describe() {
            return "Adding synthesiser recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public String describeUndo() {
            return "Removing synthesiser recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

