/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import java.util.HashMap;
import minechem.item.element.ElementAlloyEnum;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolTypeAlloy;
import minechem.item.polytool.PolytoolUpgradeType;
import minechem.item.polytool.types.PolytoolTypeArgon;
import minechem.item.polytool.types.PolytoolTypeBeryllium;
import minechem.item.polytool.types.PolytoolTypeBoron;
import minechem.item.polytool.types.PolytoolTypeBromine;
import minechem.item.polytool.types.PolytoolTypeCaesium;
import minechem.item.polytool.types.PolytoolTypeCalcium;
import minechem.item.polytool.types.PolytoolTypeCarbon;
import minechem.item.polytool.types.PolytoolTypeChlorine;
import minechem.item.polytool.types.PolytoolTypeChromium;
import minechem.item.polytool.types.PolytoolTypeFluorine;
import minechem.item.polytool.types.PolytoolTypeFrancium;
import minechem.item.polytool.types.PolytoolTypeGold;
import minechem.item.polytool.types.PolytoolTypeHelium;
import minechem.item.polytool.types.PolytoolTypeHydrogen;
import minechem.item.polytool.types.PolytoolTypeIron;
import minechem.item.polytool.types.PolytoolTypeKrypton;
import minechem.item.polytool.types.PolytoolTypeLead;
import minechem.item.polytool.types.PolytoolTypeMagnesium;
import minechem.item.polytool.types.PolytoolTypeMercury;
import minechem.item.polytool.types.PolytoolTypeNeon;
import minechem.item.polytool.types.PolytoolTypeNickel;
import minechem.item.polytool.types.PolytoolTypeNitrogen;
import minechem.item.polytool.types.PolytoolTypeOxygen;
import minechem.item.polytool.types.PolytoolTypePhosphorus;
import minechem.item.polytool.types.PolytoolTypePlatnium;
import minechem.item.polytool.types.PolytoolTypeRubidium;
import minechem.item.polytool.types.PolytoolTypeSilicon;
import minechem.item.polytool.types.PolytoolTypeSilver;
import minechem.item.polytool.types.PolytoolTypeSodium;
import minechem.item.polytool.types.PolytoolTypeSulfur;
import minechem.item.polytool.types.PolytoolTypeTitanium;
import minechem.item.polytool.types.PolytoolTypeUranium;
import minechem.item.polytool.types.PolytoolTypeZirconium;

public class PolytoolHelper {
    public static HashMap<ElementEnum, PolytoolUpgradeType> types = new HashMap();

    public static PolytoolUpgradeType getTypeFromElement(ElementEnum element, float power) {
        if (types.containsKey(element)) {
            return types.get(element).setPower(power);
        }
        return null;
    }

    private static void register(PolytoolUpgradeType upgradeType) {
        if (!types.containsKey(upgradeType.getElement())) {
            types.put(upgradeType.getElement(), upgradeType);
        }
    }

    static {
        PolytoolHelper.register(new PolytoolTypeArgon());
        PolytoolHelper.register(new PolytoolTypeBeryllium());
        PolytoolHelper.register(new PolytoolTypeBoron());
        PolytoolHelper.register(new PolytoolTypeBromine());
        PolytoolHelper.register(new PolytoolTypeCaesium());
        PolytoolHelper.register(new PolytoolTypeCalcium());
        PolytoolHelper.register(new PolytoolTypeCarbon());
        PolytoolHelper.register(new PolytoolTypeChlorine());
        PolytoolHelper.register(new PolytoolTypeChromium());
        PolytoolHelper.register(new PolytoolTypeFluorine());
        PolytoolHelper.register(new PolytoolTypeFrancium());
        PolytoolHelper.register(new PolytoolTypeGold());
        PolytoolHelper.register(new PolytoolTypeHelium());
        PolytoolHelper.register(new PolytoolTypeHydrogen());
        PolytoolHelper.register(new PolytoolTypeIron());
        PolytoolHelper.register(new PolytoolTypeKrypton());
        PolytoolHelper.register(new PolytoolTypeLead());
        PolytoolHelper.register(new PolytoolTypeMagnesium());
        PolytoolHelper.register(new PolytoolTypeMercury());
        PolytoolHelper.register(new PolytoolTypeNeon());
        PolytoolHelper.register(new PolytoolTypeNickel());
        PolytoolHelper.register(new PolytoolTypeNitrogen());
        PolytoolHelper.register(new PolytoolTypeOxygen());
        PolytoolHelper.register(new PolytoolTypePhosphorus());
        PolytoolHelper.register(new PolytoolTypePlatnium());
        PolytoolHelper.register(new PolytoolTypeRubidium());
        PolytoolHelper.register(new PolytoolTypeSilicon());
        PolytoolHelper.register(new PolytoolTypeSilver());
        PolytoolHelper.register(new PolytoolTypeSodium());
        PolytoolHelper.register(new PolytoolTypeSulfur());
        PolytoolHelper.register(new PolytoolTypeTitanium());
        PolytoolHelper.register(new PolytoolTypeUranium());
        PolytoolHelper.register(new PolytoolTypeZirconium());
        for (ElementAlloyEnum alloy : ElementAlloyEnum.values()) {
            PolytoolHelper.register(new PolytoolTypeAlloy(alloy));
        }
    }
}

