/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.molecule;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.fluid.FluidHelper;
import minechem.fluid.FluidMolecule;
import minechem.gui.CreativeTabMinechem;
import minechem.item.element.ElementItem;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.polytool.PolytoolHelper;
import minechem.potion.PharmacologyEffect;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.utils.EnumColour;
import minechem.utils.MinechemUtil;
import minechem.utils.TimeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.input.Keyboard;

public class MoleculeItem
extends Item {
    public IIcon render_pass1;
    public IIcon render_pass2;
    public IIcon filledMolecule;

    public MoleculeItem() {
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_ELEMENTS);
        this.func_77627_a(true);
        this.func_77655_b("itemMolecule");
    }

    public String func_77653_i(ItemStack itemStack) {
        return MinechemUtil.getLocalString(MoleculeItem.getMolecule(itemStack).getUnlocalizedName(), true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("minechem:filledTestTube");
        this.render_pass1 = ir.func_94245_a("minechem:Molecule_Pass1");
        this.render_pass2 = ir.func_94245_a("minechem:Molecule_Pass2");
        this.filledMolecule = ir.func_94245_a("minechem:filledMolecule");
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return this.func_77658_a() + "." + MoleculeItem.getMolecule(par1ItemStack).name();
    }

    public String getFormulaWithSubscript(ItemStack itemstack) {
        String formula = MoleculeItem.getMolecule(itemstack).getFormula();
        return MinechemUtil.subscriptNumbers(formula);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add("\u00a79" + this.getFormulaWithSubscript(itemstack));
        RadiationEnum radioactivity = RadiationInfo.getRadioactivity(itemstack);
        String radioactivityColor = radioactivity.getColour();
        String radioactiveName = MinechemUtil.getLocalString("element.property." + radioactivity.name(), true);
        String timeLeft = "";
        if (RadiationInfo.getRadioactivity(itemstack) != RadiationEnum.stable && itemstack.func_77978_p() != null) {
            long worldTime = player.field_70170_p.func_82737_E();
            timeLeft = TimeHelper.getTimeFromTicks(RadiationInfo.getRadioactivity(itemstack).getLife() - (worldTime - itemstack.func_77978_p().func_74763_f("decayStart")));
        }
        list.add(radioactivityColor + radioactiveName + (timeLeft.equals("") ? "" : " (" + timeLeft + ")"));
        list.add(MoleculeItem.getRoomState(itemstack));
        MoleculeEnum molecule = MoleculeEnum.getById(itemstack.func_77960_j());
        if (PharmacologyEffectRegistry.hasEffect(molecule) && Settings.displayMoleculeEffects && PolytoolHelper.getTypeFromElement(ElementItem.getElement(itemstack), 1.0f) != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                for (PharmacologyEffect effect : PharmacologyEffectRegistry.getEffects(molecule)) {
                    list.add(effect.getColour() + effect.toString());
                }
            } else {
                list.add((Object)((Object)EnumColour.DARK_GREEN) + MinechemUtil.getLocalString("effect.information", true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            par3List.add(new ItemStack(item, 1, molecule.id()));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean result;
        TileEntity te = world.func_147438_o(x, y, z);
        boolean bl = result = !world.field_72995_K;
        if (te != null && te instanceof IFluidHandler && !player.func_70093_af() && !(te instanceof IInventory)) {
            int filled = 0;
            for (int i = 0; i < 6; ++i) {
                FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 125);
                if (MoleculeItem.getMolecule(stack) != MoleculeEnum.water) {
                    FluidMolecule fluid = FluidHelper.molecules.get(MoleculeItem.getMolecule(stack));
                    if (fluid == null) {
                        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
                    }
                    fluidStack = new FluidStack((Fluid)fluid, 125);
                }
                if ((filled = ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)i), fluidStack, false)) <= 0) continue;
                if (result) {
                    ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)i), fluidStack, true);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)MinechemItemsRegistration.element, 1, 0));
                }
                return result || stack.field_77994_a <= 0;
            }
            return result;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public static MoleculeEnum getMolecule(ItemStack itemstack) {
        int itemDamage = itemstack.func_77960_j();
        MoleculeEnum mol = MoleculeEnum.getById(itemDamage);
        if (mol == null) {
            itemstack.func_77964_b(0);
            mol = MoleculeEnum.getById(0);
        }
        return mol;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
        if (world.field_72995_K) {
            return itemStack;
        }
        MoleculeEnum molecule = MoleculeItem.getMolecule(itemStack);
        PharmacologyEffectRegistry.applyEffect(molecule, (EntityLivingBase)entityPlayer);
        world.func_72956_a((Entity)entityPlayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return itemStack;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        MovingObjectPosition movingObjectPosition = this.func_77621_a(world, player, false);
        if (movingObjectPosition == null || player.func_70093_af()) {
            return itemStack;
        }
        if (movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int blockX = movingObjectPosition.field_72311_b;
            int blockY = movingObjectPosition.field_72312_c;
            int blockZ = movingObjectPosition.field_72309_d;
            ForgeDirection dir = ForgeDirection.getOrientation((int)movingObjectPosition.field_72310_e);
            if (!player.func_82247_a(blockX += dir.offsetX, blockY += dir.offsetY, blockZ += dir.offsetZ, movingObjectPosition.field_72310_e, itemStack)) {
                return itemStack;
            }
            return this.emptyTube(itemStack, player, world, blockX, blockY, blockZ);
        }
        return itemStack;
    }

    private ItemStack emptyTube(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z) && !world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            Block sourceBlock = world.func_147439_a(x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            sourceBlock.func_149636_a(world, player, x, y, z, metadata);
            sourceBlock.func_149749_a(world, x, y, z, sourceBlock, metadata);
            world.func_147468_f(x, y, z);
        }
        if (world.func_147437_c(x, y, z)) {
            RadiationInfo radioactivity = ElementItem.getRadiationInfo(itemStack, world);
            long worldtime = world.func_82737_E();
            long leftTime = radioactivity.radioactivity.getLife() - (worldtime - radioactivity.decayStarted);
            MoleculeEnum molecule = MoleculeItem.getMolecule(itemStack);
            Fluid fluid = FluidHelper.molecules.get(molecule);
            if (fluid == null) {
                return itemStack;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemStack.field_77994_a >= 8) {
                    itemStack.field_77994_a -= 8;
                } else {
                    int needs = 8 - itemStack.field_77994_a;
                    Set<ItemStack> otherItemsStacks = MinechemUtil.findItemStacks((IInventory)player.field_71071_by, itemStack.func_77973_b(), itemStack.func_77960_j());
                    otherItemsStacks.remove(itemStack);
                    int free = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        free += stack.field_77994_a;
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    itemStack.field_77994_a = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        RadiationInfo anotherRadiation = ElementItem.getRadiationInfo(stack, world);
                        long anotherLeft = anotherRadiation.radioactivity.getLife() - (worldtime - anotherRadiation.decayStarted);
                        if (anotherLeft < leftTime) {
                            radioactivity = anotherRadiation;
                            leftTime = anotherLeft;
                        }
                        if (stack.field_77994_a >= needs) {
                            stack.field_77994_a -= needs;
                            needs = 0;
                        } else {
                            needs -= stack.field_77994_a;
                            stack.field_77994_a = 0;
                        }
                        if (stack.field_77994_a <= 0) {
                            MinechemUtil.removeStackInInventory((IInventory)player.field_71071_by, stack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                ItemStack empties = MinechemUtil.addItemToInventory((IInventory)player.field_71071_by, new ItemStack((Item)MinechemItemsRegistration.element, 8, 0));
                MinechemUtil.throwItemStack(world, empties, x, y, z);
            }
            BlockLiquid block = Blocks.field_150358_i;
            if (MoleculeItem.getMolecule(itemStack) != MoleculeEnum.water) {
                block = (Block)FluidHelper.moleculeBlocks.get(fluid);
            }
            world.func_147465_d(x, y, z, (Block)block, 0, 3);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (radioactivity.isRadioactive() && tile instanceof RadiationFluidTileEntity) {
                ((RadiationFluidTileEntity)tile).info = radioactivity;
            }
        }
        return itemStack;
    }

    public static String getRoomState(ItemStack itemstack) {
        int id = itemstack.func_77960_j();
        return MoleculeEnum.molecules.get(id) == null ? "null" : MoleculeEnum.molecules.get(id).roomState().descriptiveName();
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        if (RadiationInfo.getRadioactivity(itemStack) != RadiationEnum.stable && itemStack.field_77990_d == null) {
            RadiationInfo.setRadiationInfo(new RadiationInfo(itemStack, world.func_82737_E(), world.func_82737_E(), world.field_73011_w.field_76574_g, RadiationInfo.getRadioactivity(itemStack)), itemStack);
        }
    }
}

