/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.chemistjournal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import minechem.Minechem;
import minechem.gui.CreativeTabMinechem;
import minechem.utils.MinechemUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ChemistJournalItem
extends Item {
    public static final String ITEMS_TAG_NAME = "discoveredItems";
    private static final String ACTIVE_ITEMSTACK_TAG = "activeItemStack";
    private static final String JOURNAL_OWNER_TAG = "owner";

    public ChemistJournalItem() {
        this.func_77655_b("itemChemistJournal");
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_ITEMS);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)Minechem.INSTANCE, 1, world, entityPlayer.field_70176_ah, entityPlayer.field_70162_ai, entityPlayer.field_70162_ai);
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            tagCompound.func_74778_a(JOURNAL_OWNER_TAG, entityPlayer.getDisplayName());
            itemStack.func_77982_d(tagCompound);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        NBTTagCompound stackTag = itemStack.func_77978_p();
        if (stackTag != null) {
            NBTTagCompound activeTag = (NBTTagCompound)stackTag.func_74781_a(ACTIVE_ITEMSTACK_TAG);
            if (activeTag != null) {
                ItemStack activeItemStack = ItemStack.func_77949_a((NBTTagCompound)activeTag);
                list.add("Active: " + activeItemStack.func_82833_r());
            }
            String owner = stackTag.func_74779_i(JOURNAL_OWNER_TAG);
            String ownerTag = MinechemUtil.getLocalString("minechem.owner.tag");
            if (ownerTag.isEmpty() || ownerTag.equals("minechem.owner.tag")) {
                list.add("Owner: " + owner);
            } else {
                list.add(ownerTag + ": " + owner);
            }
        }
    }

    public void setActiveStack(ItemStack itemstack, ItemStack journalStack) {
        NBTTagCompound journalTag = journalStack.func_77978_p();
        if (journalTag == null) {
            journalTag = new NBTTagCompound();
        }
        NBTTagCompound stackTag = itemstack.func_77955_b(new NBTTagCompound());
        journalTag.func_74782_a(ACTIVE_ITEMSTACK_TAG, (NBTBase)stackTag);
        journalStack.func_77982_d(journalTag);
    }

    public ItemStack getActiveStack(ItemStack journalStack) {
        NBTTagCompound stackTag;
        NBTTagCompound journalTag = journalStack.func_77978_p();
        if (journalTag != null && (stackTag = (NBTTagCompound)journalTag.func_74781_a(ACTIVE_ITEMSTACK_TAG)) != null) {
            return ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
        return null;
    }

    public List<ItemStack> getItemList(ItemStack journal) {
        NBTTagList taglist;
        NBTTagCompound tag = journal.func_77978_p();
        if (tag != null && (taglist = tag.func_150295_c(ITEMS_TAG_NAME, 10)) != null) {
            return MinechemUtil.readTagListToItemStackList(taglist);
        }
        return null;
    }

    public void addItemStackToJournal(ItemStack itemstack, ItemStack journal, World world) {
        ArrayList<ItemStack> itemArrayList;
        NBTTagList taglist;
        NBTTagCompound tagCompound = journal.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((taglist = tagCompound.func_150295_c(ITEMS_TAG_NAME, 10)) == null) {
            taglist = new NBTTagList();
        }
        if (!this.hasDiscovered(itemArrayList = MinechemUtil.readTagListToItemStackList(taglist), itemstack)) {
            taglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74782_a(ITEMS_TAG_NAME, (NBTBase)taglist);
            journal.func_77982_d(tagCompound);
        }
    }

    private boolean hasDiscovered(ArrayList<ItemStack> list, ItemStack itemstack) {
        for (ItemStack itemstack2 : list) {
            if (!itemstack.func_77969_a(itemstack2)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("minechem:ChemistJournal");
    }
}

