/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.bucket;

import minechem.fluid.FluidElement;
import minechem.fluid.FluidMolecule;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.molecule.MoleculeEnum;
import minechem.render.RenderingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class MinechemBucketRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack itemstack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack itemstack, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemstack, Object ... data) {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        MinechemBucketItem item = (MinechemBucketItem)itemstack.func_77973_b();
        Fluid fluid = item.fluid;
        IIcon bucket = item.icons[0];
        IIcon pass = item.icons[1];
        switch (type) {
            case ENTITY: {
                EntityItem entityItem = (EntityItem)data[1];
                if (entityItem.field_70170_p == null) {
                    float angle = (float)(Minecraft.func_71386_F() % 8000L) / 8000.0f * 360.0f;
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.2f, (float)-0.5f, (float)0.0f);
                    this.renderItemAsEntity(bucket, pass, fluid);
                    GL11.glPopMatrix();
                    break;
                }
                this.renderItemAsEntity(bucket, pass, fluid);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                Tessellator tessellator = Tessellator.field_78398_a;
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)bucket.func_94212_f(), (float)bucket.func_94206_g(), (float)bucket.func_94209_e(), (float)bucket.func_94210_h(), (int)bucket.func_94211_a(), (int)bucket.func_94216_b(), (float)0.0625f);
                this.colorFluid(fluid);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)pass.func_94212_f(), (float)pass.func_94206_g(), (float)pass.func_94209_e(), (float)pass.func_94210_h(), (int)pass.func_94211_a(), (int)pass.func_94216_b(), (float)0.0625f);
                break;
            }
            case INVENTORY: {
                RenderingUtil.drawTexturedRectUV(type, 0.0f, 0.0f, 5.0f, 16.0f, 16.0f, bucket);
                this.colorFluid(fluid);
                RenderingUtil.drawTexturedRectUV(type, 0.0f, 0.0f, 5.0f, 16.0f, 16.0f, pass);
                break;
            }
        }
    }

    private void colorFluid(Fluid fluid) {
        if (fluid instanceof FluidElement) {
            RenderingUtil.setColorForElement(((FluidElement)fluid).element);
        } else if (fluid instanceof FluidMolecule) {
            MoleculeEnum molecule = ((FluidMolecule)fluid).molecule;
            GL11.glColor3f((float)molecule.red, (float)molecule.green, (float)molecule.blue);
        }
    }

    private void renderItemAsEntity(IIcon bucket, IIcon pass, Fluid fluid) {
        GL11.glPushMatrix();
        RenderingUtil.drawTextureIn3D(bucket);
        this.colorFluid(fluid);
        RenderingUtil.drawTextureIn3D(pass);
        GL11.glPopMatrix();
    }
}

