/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import java.util.Random;
import minechem.Settings;
import minechem.fluid.ExplosiveFluidHandler;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMolecule;
import minechem.fluid.MinechemFluid;
import minechem.fluid.reaction.ChemicalFluidReactionHandler;
import minechem.item.ChemicalRoomStateEnum;
import minechem.item.MinechemChemicalType;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class MinechemFluidBlock
extends BlockFluidClassic
implements ITileEntityProvider {
    private final boolean isRadioactivity;
    public static final Material materialFluidBlock = new MaterialLiquid(MapColor.field_151662_n);
    private final boolean solid;

    public MinechemFluidBlock(MinechemFluid fluid, Material material) {
        super((Fluid)fluid, material);
        this.setQuantaPerBlock(fluid.getQuanta());
        this.isRadioactivity = fluid instanceof FluidElement ? ((FluidElement)fluid).element.radioactivity() != RadiationEnum.stable : (fluid instanceof FluidMolecule ? ((FluidMolecule)fluid).molecule.radioactivity() != RadiationEnum.stable : false);
        this.field_149758_A = true;
        this.solid = fluid.getChemical().roomState() == ChemicalRoomStateEnum.solid;
    }

    public String func_149739_a() {
        String fluidUnlocalizedName = this.getFluid().getUnlocalizedName();
        return fluidUnlocalizedName.substring(0, fluidUnlocalizedName.length() - 5);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        this.checkStatus(world, x, y, z);
    }

    public void checkStatus(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        if (Settings.reactionFluidMeetFluid) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!this.checkToReact(world, x + face.func_82601_c(), y + face.func_96559_d(), z + face.func_82599_e(), x, y, z)) continue;
                return;
            }
        }
        this.checkToExplode(world, x, y, z);
    }

    private boolean checkToReact(World world, int dx, int dy, int dz, int sx, int sy, int sz) {
        return ChemicalFluidReactionHandler.checkToReact((Block)this, world.func_147439_a(dx, dy, dz), world, dx, dy, dz, sx, sy, sz);
    }

    private void checkToExplode(World world, int x, int y, int z) {
        MinechemChemicalType type = MinechemUtil.getChemical((Block)this);
        float level = ExplosiveFluidHandler.getInstance().getExplosiveFluid(type);
        if (Float.isNaN(level)) {
            return;
        }
        boolean flag = false;
        for (EnumFacing face : EnumFacing.values()) {
            if (!ExplosiveFluidHandler.getInstance().existingFireSource(world.func_147439_a(x + face.func_82601_c(), y + face.func_96559_d(), z + face.func_82599_e()))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return;
        }
        world.func_147480_a(x, y, z, true);
        world.func_147468_f(x, y, z);
        world.func_72876_a(null, (double)x, (double)y, (double)z, ExplosiveFluidHandler.getInstance().getExplosiveFluid(type), true);
    }

    public boolean hasTileEntity(int metadata) {
        return this.isRadioactivity && metadata == 0;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return this.hasTileEntity(metadata) ? new RadiationFluidTileEntity() : null;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParameter) {
        super.func_149696_a(world, x, y, z, eventID, eventParameter);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(eventID, eventParameter) : false;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        MinechemChemicalType type = MinechemUtil.getChemical((Block)this);
        world.func_147480_a(x, y, z, true);
        world.func_147468_f(x, y, z);
        world.func_72876_a(null, (double)x, (double)y, (double)z, ExplosiveFluidHandler.getInstance().getExplosiveFluid(type), true);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.solid) {
            super.func_149674_a(world, x, y, z, rand);
        }
        this.checkStatus(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.checkStatus(world, x, y, z);
    }
}

