/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.util;

import lumaceon.mods.clockworkphase.util.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static boolean hasTag(ItemStack is, String keyName) {
        return is != null && is.field_77990_d != null && is.field_77990_d.func_74764_b(keyName);
    }

    public static void removeTag(ItemStack is, String keyName) {
        if (is.field_77990_d != null) {
            is.field_77990_d.func_82580_o(keyName);
        }
    }

    private static void initNBTTagCompound(ItemStack is) {
        if (is.field_77990_d == null) {
            is.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setNBTTagListFromInventory(ItemStack is, String keyName, ItemStack[] inventory) {
        NBTHelper.initNBTTagCompound(is);
        NBTTagList nbtList = new NBTTagList();
        for (int index = 0; index < inventory.length; ++index) {
            if (inventory[index] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("slot_index", (byte)index);
            inventory[index].func_77955_b(tag);
            nbtList.func_74742_a((NBTBase)tag);
        }
        NBTHelper.setTagList(is, keyName, nbtList);
    }

    public static ItemStack[] getInventoryFromNBTTag(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            return null;
        }
        NBTTagList nbt = NBTHelper.getTagList(is, keyName);
        ItemStack[] inventory = new ItemStack[nbt.func_74745_c()];
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = nbt.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("slot_index");
            if (slotIndex < 0 || slotIndex >= inventory.length) continue;
            inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        return inventory;
    }

    public static void setTag(ItemStack is, String keyName, NBTBase nbt) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74782_a(keyName, nbt);
    }

    public static void setTagList(ItemStack is, String keyName, NBTTagList nbt) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74782_a(keyName, (NBTBase)nbt);
    }

    public static NBTBase getTag(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setTagList(is, keyName, new NBTTagList());
        }
        return is.field_77990_d.func_74781_a(keyName);
    }

    public static NBTTagList getTagList(ItemStack is, String keyName) {
        NBTBase returnValue;
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setTagList(is, keyName, new NBTTagList());
        }
        if (!((returnValue = is.field_77990_d.func_74781_a(keyName)) instanceof NBTTagList)) {
            Logger.error("Method getTagList in NBTHelper attempted to load an invalid tag.");
            return new NBTTagList();
        }
        return (NBTTagList)returnValue;
    }

    public static void setLong(ItemStack is, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74772_a(keyName, keyValue);
    }

    public static String getString(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setString(is, keyName, "");
        }
        return is.field_77990_d.func_74779_i(keyName);
    }

    public static void setString(ItemStack is, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74778_a(keyName, keyValue);
    }

    public static boolean getBoolean(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setBoolean(is, keyName, false);
        }
        return is.field_77990_d.func_74767_n(keyName);
    }

    public static void setBoolean(ItemStack is, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74757_a(keyName, keyValue);
    }

    public static byte getByte(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setByte(is, keyName, (byte)0);
        }
        return is.field_77990_d.func_74771_c(keyName);
    }

    public static void setByte(ItemStack is, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74774_a(keyName, keyValue);
    }

    public static short getShort(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setShort(is, keyName, (short)0);
        }
        return is.field_77990_d.func_74765_d(keyName);
    }

    public static void setShort(ItemStack is, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74777_a(keyName, keyValue);
    }

    public static int getInt(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setInteger(is, keyName, 0);
        }
        return is.field_77990_d.func_74762_e(keyName);
    }

    public static void setInteger(ItemStack is, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74768_a(keyName, keyValue);
    }

    public static long getLong(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setLong(is, keyName, 0L);
        }
        return is.field_77990_d.func_74763_f(keyName);
    }

    public static float getFloat(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setFloat(is, keyName, 0.0f);
        }
        return is.field_77990_d.func_74760_g(keyName);
    }

    public static void setFloat(ItemStack is, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74776_a(keyName, keyValue);
    }

    public static double getDouble(ItemStack is, String keyName) {
        NBTHelper.initNBTTagCompound(is);
        if (!is.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setDouble(is, keyName, 0.0);
        }
        return is.field_77990_d.func_74769_h(keyName);
    }

    public static void setDouble(ItemStack is, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(is);
        is.field_77990_d.func_74780_a(keyName, keyValue);
    }
}

