/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.clockwork.tool;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lumaceon.mods.clockworkphase.init.ModBlocks;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.construct.IKeybindAbility;
import lumaceon.mods.clockworkphase.item.construct.ITemporalChange;
import lumaceon.mods.clockworkphase.item.construct.clockwork.tool.ItemClockworkShovel;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.ValidBlockLists;
import lumaceon.mods.clockworkphase.network.MessageTemporalItemChange;
import lumaceon.mods.clockworkphase.network.PacketHandler;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.TimeSandParser;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.input.Keyboard;

public class ItemTemporalClockworkShovel
extends ItemClockworkShovel
implements IKeybindAbility,
ITemporalChange {
    public ItemTemporalClockworkShovel(Item.ToolMaterial mat) {
        super(mat);
        this.func_77637_a(null);
    }

    public void func_77663_a(ItemStack is, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int timeSand = this.getTimeSand(is);
            if ((timeSand += this.getTimeSandFromInventory((IInventory)player.field_71071_by)) < MechanicTweaker.TIME_SAND_PER_BLOCK_BREAK_SHOVEL && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c) != null && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c).equals(is)) {
                ItemStack newItem = new ItemStack(this.getItemChangeTo());
                newItem.func_77982_d(is.field_77990_d);
                newItem.func_77964_b(is.func_77960_j());
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        list.add("Tension: \u00a7e" + NBTHelper.getInt(is, "tension_energy") + "/" + "\u00a7e" + NBTHelper.getInt(is, "max_tension"));
        int timeSand = this.getTimeSand(is);
        if (timeSand > 0) {
            list.add(TimeSandParser.getStringForRenderingFromTimeSand(timeSand));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("");
            list.add("Clockwork Quality: \u00a7e" + NBTHelper.getInt(is, "cp_quality") + " " + "\u00a7b" + "x 3");
            list.add("Clockwork Speed: \u00a7e" + NBTHelper.getInt(is, "cp_speed") + " " + "\u00a7b" + "x 3");
            list.add("Memory: \u00a7e" + NBTHelper.getInt(is, "cp_memory"));
            list.add("");
        } else {
            list.add("-Hold shift for details-");
        }
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int meta, float f1, float f2, float f3) {
        if (ValidBlockLists.BlockShovelables.isBlockValidShovelable(world.func_147439_a(x, y, z)) && world.func_72962_a(player, x, y, z)) {
            int amountToRemove = 30;
            if (this.getTimeSandFromInventory((IInventory)player.field_71071_by) >= amountToRemove || this.getTimeSand(is) >= amountToRemove) {
                amountToRemove -= this.removeTimeSandFromInventory((IInventory)player.field_71071_by, amountToRemove);
                this.removeTimeSand(is, amountToRemove);
                world.func_147449_b(x, y, z, ModBlocks.sandTemporal);
                world.func_147480_a(x, y, z, true);
                world.func_147459_d(x, y, z, world.func_147439_a(x, y, z));
            }
        }
        return false;
    }

    @Override
    public boolean func_150894_a(ItemStack is, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        super.func_150894_a(is, world, block, x, y, z, entity);
        if (entity != null && entity instanceof EntityPlayer) {
            if (this.func_150893_a(is, block) <= 1.0f) {
                return true;
            }
            int amountToRemove = MechanicTweaker.TIME_SAND_PER_BLOCK_BREAK_SHOVEL;
            EntityPlayer player = (EntityPlayer)entity;
            amountToRemove -= this.removeTimeSandFromInventory((IInventory)player.field_71071_by, amountToRemove);
            if ((amountToRemove -= this.removeTimeSand(is, amountToRemove)) > 0) {
                ItemStack newItem = new ItemStack(this.getItemChangeTo());
                newItem.func_77982_d(is.field_77990_d);
                newItem.func_77964_b(is.func_77960_j());
                if (player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c).equals(is)) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
                }
            }
        }
        return true;
    }

    @Override
    public float func_150893_a(ItemStack is, Block block) {
        float efficiency = super.func_150893_a(is, block);
        if (efficiency == 1.0f) {
            return efficiency;
        }
        int tension = NBTHelper.getInt(is, "tension_energy");
        if (tension <= 0) {
            return 1.0f;
        }
        int speed = NBTHelper.getInt(is, "cp_speed");
        if (speed <= 0) {
            return 1.0f;
        }
        return super.func_150893_a(is, block) * 3.0f;
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            int tension = NBTHelper.getInt(stack, "tension_energy");
            if (tension <= 0) {
                return 1.0f;
            }
            int speed = NBTHelper.getInt(stack, "cp_speed");
            if (speed <= 0) {
                return 1.0f;
            }
            return super.getDigSpeed(stack, block, meta) * 3.0f;
        }
        return this.func_150893_a(stack, block);
    }

    @Override
    public void disassemble(World world, double x, double y, double z, ItemStack is) {
    }

    @Override
    public void useTemporalAbility() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTemporalItemChange());
    }

    @Override
    public Item getItemChangeTo() {
        return ModItems.clockworkShovel;
    }
}

