/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.extendeddata;

import lumaceon.mods.clockworkphase.phaseevent.PhaseEventAbstract;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class ExtendedWorldData
extends WorldSavedData {
    public static final String ID = "clockworkphase_world_save_data";
    public PhaseEventAbstract phaseEvent;

    public ExtendedWorldData() {
        super(ID);
    }

    public ExtendedWorldData(String id) {
        super(id);
    }

    public void setWorldPhaseEvent(PhaseEventAbstract event, World world) {
        block4: {
            block3: {
                this.phaseEvent = event.copy();
                this.func_76185_a();
                if (this.phaseEvent.warmupTime <= 40) break block3;
                if (world.field_72995_K || this.phaseEvent.getWarningMessage().isEmpty()) break block4;
                for (int n = 0; n < world.field_73010_i.size(); ++n) {
                    ((EntityPlayer)world.field_73010_i.get(n)).func_146105_b((IChatComponent)new ChatComponentText(this.phaseEvent.getWarningMessage()));
                }
                break block4;
            }
            if (this.phaseEvent.warmupTime < 0 && !world.field_72995_K && !this.phaseEvent.getActivationMessage().isEmpty()) {
                for (int n = 0; n < world.field_73010_i.size(); ++n) {
                    ((EntityPlayer)world.field_73010_i.get(n)).func_146105_b((IChatComponent)new ChatComponentText(this.phaseEvent.getActivationMessage()));
                }
            }
        }
    }

    public void removeWorldPhaseEvent(World world) {
        if (!world.field_72995_K && !this.phaseEvent.getDeactivationMessage().isEmpty()) {
            for (int n = 0; n < world.field_73010_i.size(); ++n) {
                ((EntityPlayer)world.field_73010_i.get(n)).func_146105_b((IChatComponent)new ChatComponentText(this.phaseEvent.getDeactivationMessage()));
            }
        }
        this.phaseEvent = null;
        this.func_76185_a();
    }

    public void func_76187_b(NBTTagCompound nbt) {
        if (this.phaseEvent != null) {
            nbt.func_74768_a("cp_phase", this.phaseEvent.getPhase().ordinal());
            nbt.func_74768_a("phase_id", this.phaseEvent.ID);
            NBTTagCompound compound = new NBTTagCompound();
            this.phaseEvent.writeToNBT(compound);
            nbt.func_74782_a("phase_event_data", (NBTBase)compound);
        } else {
            nbt.func_82580_o("cp_phase");
            nbt.func_82580_o("phase_id");
            nbt.func_82580_o("phase_event_data");
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (this.phaseEvent == null) {
            this.phaseEvent = PhaseEventAbstract.getPhaseEventFromNBT(nbt);
            this.func_76185_a();
        }
    }

    public static ExtendedWorldData get(World world) {
        ExtendedWorldData dataHandler = (ExtendedWorldData)world.perWorldStorage.func_75742_a(ExtendedWorldData.class, ID);
        if (dataHandler == null) {
            dataHandler = new ExtendedWorldData();
            world.perWorldStorage.func_75745_a(ID, (WorldSavedData)dataHandler);
        }
        return dataHandler;
    }
}

