/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.client.gui.container;

import java.util.ArrayList;
import lumaceon.mods.clockworkphase.ClockworkPhase;
import lumaceon.mods.clockworkphase.api.MainspringMetal;
import lumaceon.mods.clockworkphase.client.gui.components.SlotMainspring;
import lumaceon.mods.clockworkphase.client.gui.components.SlotMainspringMetals;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.inventory.InventoryMainspringAssembly;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ContainerClockworkAssemblyTableMainspring
extends Container {
    private InventoryMainspringAssembly matrix = new InventoryMainspringAssembly(this);
    private InventoryCraftResult result = new InventoryCraftResult();
    private World world;

    public ContainerClockworkAssemblyTableMainspring(InventoryPlayer ip, World world) {
        int x;
        this.world = world;
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)ip, x, 48 + x * 18, 232));
        }
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.func_75146_a(new Slot((IInventory)ip, 9 + y + x * 3, 48 + x * 18, 174 + y * 18));
            }
        }
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 0, 102, 57));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 1, 120, 57));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 2, 138, 57));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 3, 138, 75));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 4, 138, 93));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 5, 120, 93));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 6, 102, 93));
        this.func_75146_a(new SlotMainspringMetals(this.matrix, 7, 102, 75));
        this.func_75146_a(new SlotMainspring((IInventory)this.result, 0, 120, 75));
        this.func_75130_a(this.matrix);
    }

    public void addToMainspring() {
        ItemStack mainspring = this.result.func_70301_a(0);
        if (mainspring != null && mainspring.func_77973_b().equals(ModItems.mainspring)) {
            int totalMetalValue = 0;
            for (int i = 0; i < 8; ++i) {
                ItemStack item = this.matrix.func_70301_a(i);
                if (item == null) continue;
                boolean found = false;
                for (int n = 0; n < ClockworkPhase.MAINSPRING_METAL_DICTIONARY.mainspringMetals.size() && !found; ++n) {
                    MainspringMetal metal = ClockworkPhase.MAINSPRING_METAL_DICTIONARY.mainspringMetals.get(n);
                    ArrayList ores = OreDictionary.getOres((String)metal.metalName);
                    for (ItemStack temp : ores) {
                        if (!OreDictionary.itemMatches((ItemStack)temp, (ItemStack)item, (boolean)false)) continue;
                        totalMetalValue += metal.metalValue;
                        found = true;
                    }
                }
                this.matrix.func_70298_a(i, 1);
            }
            if (totalMetalValue > 0) {
                int previousMaxTension = NBTHelper.getInt(mainspring, "max_tension");
                if (!NBTHelper.hasTag(mainspring, "max_tension")) {
                    NBTHelper.setInteger(mainspring, "max_tension", totalMetalValue);
                } else if (previousMaxTension + totalMetalValue >= MechanicTweaker.MAX_TENSION) {
                    NBTHelper.setInteger(mainspring, "max_tension", MechanicTweaker.MAX_TENSION);
                } else {
                    NBTHelper.setInteger(mainspring, "max_tension", previousMaxTension + totalMetalValue);
                }
                if (mainspring.func_77958_k() == 0) {
                    mainspring.func_77964_b(0);
                } else if (MechanicTweaker.MAX_TENSION / mainspring.func_77958_k() == 0) {
                    mainspring.func_77964_b(0);
                } else {
                    mainspring.func_77964_b(mainspring.func_77958_k() - (previousMaxTension + totalMetalValue) / (MechanicTweaker.MAX_TENSION / mainspring.func_77958_k()));
                }
            }
        }
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                ItemStack itemstack = this.matrix.func_70304_b(i);
                if (itemstack == null) continue;
                p_75134_1_.func_71019_a(itemstack, false);
            }
            ItemStack item = this.result.func_70304_b(0);
            if (item != null) {
                p_75134_1_.func_71019_a(item, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.matrix.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        return null;
    }
}

