/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.superconductor;

import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.IMultiblockPart;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.superconductor.SuperConductorMod;
import com.bymarcin.zettaindustries.mods.superconductor.gui.PacketUpdateFluidAmount;
import com.bymarcin.zettaindustries.mods.superconductor.tileentity.TileEntityBase;
import com.bymarcin.zettaindustries.mods.superconductor.tileentity.TileEntityControler;
import com.bymarcin.zettaindustries.mods.superconductor.tileentity.TileEntityWire;
import com.bymarcin.zettaindustries.registry.network.Packet;
import com.bymarcin.zettaindustries.utils.Pair;
import com.bymarcin.zettaindustries.utils.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class SuperConductor
extends MultiblockControllerBase {
    ArrayList<TileEntityControler> controlersInput;
    HashMap<TileEntityControler, Pair<Integer, Integer>> controlersOutput;
    public FluidTank tank = new FluidTank(0);
    int ticksFromLastDrain = 0;
    public boolean active = false;
    private boolean lock = false;
    int ntick = 0;

    public SuperConductor(World world) {
        super(world);
        this.controlersInput = new ArrayList();
        this.controlersOutput = new HashMap();
    }

    public void validateAllControlers() {
        this.lock = false;
        this.tank.setCapacity(0);
        this.tank.setFluid(null);
        this.controlersInput.clear();
        this.controlersOutput.clear();
        for (IMultiblockPart c : this.connectedParts) {
            this.tank.setCapacity(this.tank.getCapacity() + ((TileEntityBase)c).getCoolantCapacity());
            this.tank.setFluid(new FluidStack(SuperConductorMod.coolantFluid, ((TileEntityBase)c).getCoolantAmount() + this.tank.getFluidAmount()));
            if (c instanceof TileEntityWire) continue;
            if (((TileEntityControler)c).isOutput()) {
                this.controlersOutput.put((TileEntityControler)c, new Pair<Integer, Integer>(0, 0));
                continue;
            }
            this.controlersInput.add((TileEntityControler)c);
        }
    }

    public int onReceiveEnergy(int maxRecive, boolean simulate) {
        if (this.lock || !this.active) {
            return 0;
        }
        this.lock = true;
        ArrayList<Pair<Integer, TileEntityControler>> order = new ArrayList<Pair<Integer, TileEntityControler>>();
        long requiredEnergy = 0L;
        double ratio = 0.0;
        int energyConsumed = 0;
        for (Map.Entry<TileEntityControler, Pair<Integer, Integer>> entry : this.controlersOutput.entrySet()) {
            if (entry.getValue().getKey() != this.ntick) {
                entry.getValue().setValue(entry.getKey().onReceiveEnergy(Integer.MAX_VALUE, true));
                entry.getValue().setKey(this.ntick);
            }
            order.add(new Pair<Integer, TileEntityControler>(entry.getValue().getValue(), entry.getKey()));
            requiredEnergy += (long)entry.getValue().getValue().intValue();
        }
        ratio = (double)maxRecive / (double)requiredEnergy;
        for (Pair pair : order) {
            int get = ((TileEntityControler)((Object)pair.getValue())).onReceiveEnergy((int)Math.floor((double)((Integer)pair.getKey()).intValue() * ratio), simulate);
            energyConsumed += get;
            if (simulate) continue;
            this.controlersOutput.get(pair.getValue()).setValue(this.controlersOutput.get(pair.getValue()).getValue() - get);
        }
        this.lock = false;
        return energyConsumed;
    }

    public FluidTankInfo[] getCoolantTankInfo() {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int onFillCoolant(FluidStack fluid) {
        int ratio = (int)((float)fluid.amount / (float)this.connectedParts.size());
        int get = 0;
        for (IMultiblockPart c : this.connectedParts) {
            get += ((TileEntityBase)c).addCoolant(ratio);
        }
        this.tank.setFluid(new FluidStack(SuperConductorMod.coolantFluid, this.tank.getFluidAmount() + get));
        return get;
    }

    public void renderUpdate() {
        if (WorldUtils.isServerWorld(this.worldObj)) {
            return;
        }
        for (IMultiblockPart p : this.connectedParts) {
            p.func_145831_w().func_147479_m(p.field_145851_c, p.field_145848_d, p.field_145849_e);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.controlersInput.size() + this.controlersOutput.size() < 2) {
            this.active = false;
            this.renderUpdate();
            throw new MultiblockValidationException("Wire must have minimum 2 controlers");
        }
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase arg0) {
        this.validateAllControlers();
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase arg0) {
        this.validateAllControlers();
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart arg0, NBTTagCompound arg1) {
        this.readFromNBT(arg1);
        this.validateAllControlers();
    }

    @Override
    protected void onBlockAdded(IMultiblockPart arg0) {
        if (arg0 instanceof TileEntityControler) {
            if (((TileEntityControler)arg0).isOutput()) {
                this.controlersOutput.put((TileEntityControler)arg0, new Pair<Integer, Integer>(0, 0));
            } else {
                this.controlersInput.add((TileEntityControler)arg0);
            }
        }
        this.tank.setCapacity(this.tank.getCapacity() + ((TileEntityBase)arg0).getCoolantCapacity());
        this.tank.setFluid(new FluidStack(SuperConductorMod.coolantFluid, ((TileEntityBase)arg0).getCoolantAmount() + this.tank.getFluidAmount()));
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart arg0) {
        if (arg0 instanceof TileEntityControler) {
            this.controlersInput.remove((Object)arg0);
            this.controlersOutput.remove((Object)arg0);
        }
        this.tank.setCapacity(this.tank.getCapacity() - ((TileEntityBase)arg0).getCoolantCapacity());
        this.tank.setFluid(new FluidStack(SuperConductorMod.coolantFluid, this.tank.getFluidAmount() - ((TileEntityBase)arg0).getCoolantAmount()));
    }

    @Override
    protected void onMachineAssembled() {
        this.validateAllControlers();
    }

    @Override
    protected void onMachineDisassembled() {
        this.active = false;
        this.renderUpdate();
    }

    @Override
    protected void onMachineRestored() {
        this.worldObj.func_147471_g(this.getReferenceCoord().x, this.getReferenceCoord().y, this.getReferenceCoord().z);
        this.validateAllControlers();
    }

    @Override
    protected void updateClient() {
    }

    private void taskDrain() {
        int drain = 0;
        for (IMultiblockPart c : this.connectedParts) {
            drain += ((TileEntityBase)c).drainCoolant(1);
        }
        this.tank.drain(drain, true);
    }

    public Packet getUpdatePacket(TileEntityControler c) {
        return new PacketUpdateFluidAmount(c, this.tank.getFluidAmount(), this.tank.getFluid() != null ? this.tank.getFluid().getFluidID() : 0);
    }

    @Override
    protected boolean updateServer() {
        boolean newactive;
        if (this.ticksFromLastDrain % 10 == 0) {
            for (TileEntityControler tileEntityControler : this.controlersInput) {
                tileEntityControler.updateGUI();
            }
            for (Map.Entry entry : this.controlersOutput.entrySet()) {
                ((TileEntityControler)((Object)entry.getKey())).updateGUI();
            }
        }
        if (this.ticksFromLastDrain >= 1728) {
            this.taskDrain();
            this.ticksFromLastDrain = 0;
        }
        ++this.ticksFromLastDrain;
        ++this.ntick;
        boolean bl = newactive = (double)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()) >= 0.5;
        if (newactive != this.active) {
            this.active = newactive;
            this.worldObj.func_147471_g(this.getReferenceCoord().x, this.getReferenceCoord().y, this.getReferenceCoord().z);
            this.validateAllControlers();
            this.renderUpdate();
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound arg0) {
        this.tank.writeToNBT(arg0);
        arg0.func_74768_a("ticksFromLastDrain", this.ticksFromLastDrain);
        arg0.func_74757_a("activMachine", this.active);
    }

    @Override
    public void readFromNBT(NBTTagCompound arg0) {
        this.tank = this.tank.readFromNBT(arg0);
        if (arg0.func_74764_b("ticksFromLastDrain")) {
            this.ticksFromLastDrain = arg0.func_74762_e("ticksFromLastDrain");
        }
        if (arg0.func_74764_b("activMachine")) {
            this.active = arg0.func_74767_n("activMachine");
        }
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound arg0) {
        this.tank.readFromNBT(arg0);
        boolean lactive = arg0.func_74767_n("activMachine");
        if (lactive != this.active) {
            this.active = lactive;
            this.renderUpdate();
            this.validateAllControlers();
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound arg0) {
        this.tank.writeToNBT(arg0);
        arg0.func_74757_a("activMachine", this.active);
    }

    @Override
    protected int getMaximumXSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumYSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumZSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 2;
    }

    @Override
    protected void onMachinePaused() {
    }
}

