/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import cofh.api.energy.IEnergyHandler;
import com.bymarcin.zettaindustries.mods.battery.Battery;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.gui.PowerTapContener;
import com.bymarcin.zettaindustries.mods.battery.gui.PowerTapUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BasicRectangularMultiblockTileEntityBase;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BatteryController;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityElectrode;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.utils.WorldUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPowerTap
extends BasicRectangularMultiblockTileEntityBase
implements IEnergyHandler {
    int transferMax = 0;
    int transferCurrent = 0;
    private Set<EntityPlayer> updatePlayers = new HashSet<EntityPlayer>();
    String label = "";
    private static ForgeDirection[] dirs;

    public TileEntityPowerTap() {
        dirs = Arrays.copyOf(WorldUtils.flatDirections, 5);
        TileEntityPowerTap.dirs[4] = ForgeDirection.DOWN;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    protected PowerTapUpdatePacket getUpdatePacket() {
        return new PowerTapUpdatePacket(this, this.transferCurrent, true, this.getLabel());
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    public int getTransferCurrent() {
        return this.transferCurrent;
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's frame", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's sides", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        TileEntity entityBelow = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (entityBelow instanceof TileEntityElectrode) {
            return;
        }
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap must be placed on electrode", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's bottom", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Power tap may not be placed in the battery's interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        Block b;
        super.onMachineAssembled(controller);
        this.transferMax = 0;
        int i = 1;
        while ((b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e)) == Battery.blockBigBatteryElectrode) {
            for (ForgeDirection d : dirs) {
                if (BatteryController.checkElectrolyte(this.field_145850_b, this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY - i, this.field_145849_e + d.offsetZ) == 0) continue;
                this.transferMax += Battery.electrodeTransferRate;
            }
            ++i;
        }
        if (this.transferCurrent > this.transferMax) {
            this.transferCurrent = this.transferMax;
        }
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public int onTransferEnergy() {
        if (WorldUtils.isClientWorld(this.field_145850_b) || this.isOutput() || this.getMultiblockController() == null) {
            return 0;
        }
        TileEntity tile = WorldUtils.getAdjacentTileEntity((TileEntity)this, ForgeDirection.UP);
        int energyGet = 0;
        if (WorldUtils.isEnergyHandlerFromSide(tile, ForgeDirection.VALID_DIRECTIONS[0])) {
            energyGet = ((IEnergyHandler)tile).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[0], Math.min(this.transferCurrent, ((BatteryController)this.getMultiblockController()).getStorage().getEnergyStored()), false);
        }
        ((BatteryController)this.getMultiblockController()).getStorage().modifyEnergyStored(-energyGet);
        return energyGet;
    }

    public void setTransfer(int transfer) {
        this.transferCurrent = this.field_145850_b.field_72995_K ? transfer : Math.max(0, Math.min(transfer, this.transferMax));
    }

    public void updatePowerTap() {
        for (EntityPlayer p : this.updatePlayers) {
            ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)p);
        }
    }

    public Container getContainer(EntityPlayer player) {
        return new PowerTapContener(this, player);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getMultiblockController() != null && this.isOutput() && this.getMultiblockController().isAssembled()) {
            int temp = ((BatteryController)this.getMultiblockController()).getStorage().receiveEnergy(Math.min(maxReceive, this.transferCurrent), simulate);
            if (!simulate) {
                ((BatteryController)this.getMultiblockController()).modifyLastTickBalance(temp);
            }
            return temp;
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getMultiblockController() != null && !this.isOutput() && this.getMultiblockController().isAssembled()) {
            int temp = ((BatteryController)this.getMultiblockController()).getStorage().extractEnergy(Math.min(maxExtract, this.transferCurrent), simulate);
            if (!simulate) {
                ((BatteryController)this.getMultiblockController()).modifyLastTickBalance(-temp);
            }
            return temp;
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.getMultiblockController() != null) {
            return ((BatteryController)this.getMultiblockController()).getStorage().getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getMultiblockController() != null) {
            return ((BatteryController)this.getMultiblockController()).getStorage().getMaxEnergyStored();
        }
        return 0;
    }

    public boolean isOutput() {
        return this.func_145832_p() == 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.transferCurrent = data.func_74762_e("transfer");
        if (data.func_74764_b("powertap_label")) {
            this.label = data.func_74779_i("powertap_label");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("transfer", this.transferCurrent);
        data.func_74778_a("powertap_label", this.label);
    }

    public void setIn() {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
    }

    public void setOut() {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

