/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.network;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingbook.registry.food.FoodRecipe;
import net.blay09.mods.cookingbook.registry.food.recipe.RemoteCraftingFood;
import net.minecraft.item.ItemStack;

public class MessageSyncList
implements IMessage {
    public final List<ItemStack> sortedRecipes = new ArrayList<ItemStack>();
    public final ArrayListMultimap<String, FoodRecipe> availableRecipes = ArrayListMultimap.create();

    public MessageSyncList() {
    }

    public MessageSyncList(List<ItemStack> sortedRecipes, ArrayListMultimap<String, FoodRecipe> availableRecipes) {
        this.sortedRecipes.addAll(sortedRecipes);
        this.availableRecipes.putAll(availableRecipes);
    }

    public void fromBytes(ByteBuf buf) {
        int itemCount = buf.readInt();
        for (int i = 0; i < itemCount; ++i) {
            ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            List recipeList = this.availableRecipes.get((Object)itemStack.toString());
            int recipeCount = buf.readInt();
            for (int j = 0; j < recipeCount; ++j) {
                recipeList.add(RemoteCraftingFood.read(buf));
            }
            this.sortedRecipes.add(itemStack);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.sortedRecipes.size());
        for (ItemStack itemStack : this.sortedRecipes) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemStack);
            List recipeList = this.availableRecipes.get((Object)itemStack.toString());
            buf.writeInt(recipeList.size());
            for (FoodRecipe recipe : recipeList) {
                RemoteCraftingFood.write(buf, recipe);
            }
        }
    }
}

