/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.helper;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.StringHelper;

public class SystemInfoHelper {
    private static Runtime runtime = Runtime.getRuntime();
    private static NumberFormat format = NumberFormat.getInstance();
    public static long startTime = 0L;
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");

    public static String getOSname() {
        return System.getProperty("os.name");
    }

    public static String getOSversion() {
        return System.getProperty("os.version");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch");
    }

    public static String getTotalMem() {
        return StringHelper.bytesToString(runtime.totalMemory());
    }

    public static String getUsedMem() {
        return StringHelper.bytesToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public static String getFreeMem() {
        return StringHelper.bytesToString(runtime.freeMemory());
    }

    public static String getAllocatedMem() {
        return StringHelper.bytesToString(runtime.totalMemory());
    }

    public static String getMaxMem() {
        return StringHelper.bytesToString(runtime.maxMemory());
    }

    public static String getPercentMemUse() {
        return format.format((float)runtime.totalMemory() / (float)runtime.maxMemory() * 100.0f);
    }

    public static String getUptime() {
        long uptime = System.currentTimeMillis() - startTime;
        return StringHelper.millisToString(uptime);
    }

    public static double getDimensionTPS(WorldServer worldServer) {
        double worldTickLength = (double)MathHelper.mean((long[])MinecraftServer.func_71276_C().worldTickTimes.get(worldServer.field_73011_w.field_76574_g)) * 1.0E-6;
        return Math.min(1000.0 / worldTickLength, 20.0);
    }

    public static double getWorldTickTime(WorldServer worldServer) {
        return (double)MathHelper.mean((long[])MinecraftServer.func_71276_C().worldTickTimes.get(worldServer.field_73011_w.field_76574_g)) * 1.0E-6;
    }

    public static List<String> getTPSSummary() {
        ArrayList<String> textOutput = new ArrayList<String>();
        int chunksLoaded = 0;
        textOutput.add(SystemInfoHelper.getUptime());
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            chunksLoaded += world.func_72863_F().func_73152_e();
            textOutput.add("[" + world.field_73011_w.field_76574_g + "]" + world.field_73011_w.func_80007_l() + ": " + timeFormatter.format(SystemInfoHelper.getWorldTickTime(world)) + "ms [" + timeFormatter.format(SystemInfoHelper.getDimensionTPS(world)) + "]");
        }
        textOutput.add("Total Chunks loaded: " + chunksLoaded);
        textOutput.add("Overall: " + timeFormatter.format((double)MathHelper.mean(MinecraftServer.func_71276_C().field_71311_j) * 1.0E-6) + "ms [" + Math.min(1000.0 / ((double)MathHelper.mean(MinecraftServer.func_71276_C().field_71311_j) * 1.0E-6), 20.0) + "]");
        return textOutput;
    }

    public static List<String> getTPSDetail(int dimension) {
        ArrayList<String> textOutput = new ArrayList<String>();
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
        textOutput.add("Uptime: " + SystemInfoHelper.getUptime());
        textOutput.add("Information for [" + dimension + "]" + world.field_73011_w.func_80007_l());
        textOutput.add("Players (" + world.field_73010_i.size() + "): " + SystemInfoHelper.getPlayersForDimension(dimension));
        textOutput.add("Item Entities: " + SystemInfoHelper.getItemEntityCount((ArrayList)world.field_72996_f));
        textOutput.add("Hostile Mobs: " + SystemInfoHelper.getHostileEntityCount((ArrayList)world.field_72996_f));
        textOutput.add("Passive Mobs: " + SystemInfoHelper.getPassiveEntityCount((ArrayList)world.field_72996_f));
        textOutput.add("Total Living Entities: " + SystemInfoHelper.getLivingEntityCount((ArrayList)world.field_72996_f));
        textOutput.add("Total Entities: " + world.field_72996_f.size());
        textOutput.add("Tile Entities: " + world.field_147482_g.size());
        textOutput.add("Loaded Chunks: " + world.func_72863_F().func_73152_e());
        textOutput.add("TPS: " + timeFormatter.format(SystemInfoHelper.getWorldTickTime(world)) + "ms[" + SystemInfoHelper.getDimensionTPS(world) + "]");
        return textOutput;
    }

    private static int getItemEntityCount(ArrayList<Entity> list) {
        int count = 0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityItem)) continue;
            ++count;
        }
        return count;
    }

    private static int getPassiveEntityCount(ArrayList<Entity> list) {
        int count = 0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityAnimal)) continue;
            ++count;
        }
        return count;
    }

    private static int getHostileEntityCount(ArrayList<Entity> list) {
        int count = 0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityMob)) continue;
            ++count;
        }
        return count;
    }

    private static int getLivingEntityCount(ArrayList<Entity> list) {
        int count = 0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            ++count;
        }
        return count;
    }

    private static String getPlayersForDimension(int dimension) {
        ArrayList players = (ArrayList)MinecraftServer.func_71276_C().func_71218_a((int)dimension).field_73010_i;
        if (players.size() == 0) {
            return "None";
        }
        String playersString = "";
        Iterator ite = players.iterator();
        while (ite.hasNext()) {
            playersString = playersString + ((EntityPlayer)ite.next()).func_70005_c_();
            if (ite.hasNext()) {
                playersString = playersString + ",";
                continue;
            }
            playersString = playersString + ".";
        }
        return playersString;
    }
}

