/*
 * Decompiled with CFR 0.152.
 */
package radixcore.util;

import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import radixcore.item.ItemEffect;
import radixcore.item.ItemSingle;
import radixcore.util.RadixExcept;
import radixcore.util.RadixString;

public final class RadixStartup {
    public static CreativeTabs registerCreativeTab(Class itemClass, String itemFieldName, ModMetadata metadata, String name) {
        try {
            final Field itemRefField = itemClass.getField(itemFieldName);
            String upperName = RadixString.upperFirstLetter(itemRefField.getName());
            Item item = new Item();
            item.func_77655_b(upperName);
            item.func_111206_d(metadata.modId + ":" + upperName);
            CreativeTabs returnTab = new CreativeTabs("tab" + metadata.modId + (name != null ? "." + name : "")){

                public Item func_78016_d() {
                    try {
                        return (Item)itemRefField.get(null);
                    }
                    catch (Exception e) {
                        RadixExcept.logFatalCatch(e, "Registering tab icon item");
                        return null;
                    }
                }
            };
            item.func_77637_a(returnTab);
            return returnTab;
        }
        catch (Exception e) {
            RadixExcept.logFatalCatch(e, "registering creative tab");
            return null;
        }
    }

    public static void initBaseItems(Class itemClass, ModMetadata metadata) {
        RadixStartup.initBaseItems(itemClass, null, metadata);
    }

    public static void initBaseItems(Class itemClass, CreativeTabs creativeTab, ModMetadata metadata) {
        for (Field f : itemClass.getFields()) {
            try {
                if (!Modifier.isStatic(f.getModifiers()) || f.get(null) != null || f.getType() != Item.class && f.getType() != ItemEffect.class && f.getType() != ItemSingle.class) continue;
                Item item = f.getType() == Item.class ? new Item() : (f.getType() == ItemEffect.class ? new ItemEffect() : new ItemSingle());
                String upperName = RadixString.upperFirstLetter(f.getName());
                item.func_77655_b(upperName);
                item.func_111206_d(metadata.modId + ":" + upperName);
                item.func_77637_a(creativeTab);
                f.set(null, item);
                GameRegistry.registerItem((Item)((Item)f.get(null)), (String)upperName);
            }
            catch (Exception e) {
                RadixExcept.logFatalCatch(e, "registering item " + f.getName());
            }
        }
    }

    private RadixStartup() {
    }
}

