/*
 * Decompiled with CFR 0.152.
 */
package radixcore.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.io.output.ByteArrayOutputStream;
import radixcore.util.RadixExcept;

public final class ByteBufIO {
    public static void writeObject(ByteBuf buffer, Object object) {
        ByteBufIO.writeByteArray(buffer, ByteBufIO.convertToByteArray(object));
    }

    public static Object readObject(ByteBuf buffer) {
        return ByteBufIO.convertBytesToObject(ByteBufIO.readByteArray(buffer));
    }

    public static byte[] convertToByteArray(Object obj) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream((OutputStream)byteOutput);
            objectOutput.writeObject(obj);
            objectOutput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteOutput.toByteArray();
    }

    public static Object convertBytesToObject(byte[] byteArray) {
        ByteArrayInputStream byteInput = new ByteArrayInputStream(byteArray);
        Object returnObject = null;
        try {
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            returnObject = objectInput.readObject();
            objectInput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return returnObject;
    }

    public static byte[] compress(byte[] input) {
        try {
            Deflater deflater = new Deflater();
            deflater.setLevel(9);
            deflater.setInput(input);
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(input.length);
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                byteOutput.write(buffer, 0, count);
            }
            deflater.end();
            byteOutput.close();
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            RadixExcept.logFatalCatch(e, "Error compressing byte array.");
            return null;
        }
    }

    public static byte[] decompress(byte[] input) {
        try {
            Inflater inflater = new Inflater();
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(input.length);
            byte[] buffer = new byte[1024];
            inflater.setInput(input);
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                byteOutput.write(buffer, 0, count);
            }
            inflater.end();
            byteOutput.close();
            return byteOutput.toByteArray();
        }
        catch (DataFormatException e) {
            RadixExcept.logFatalCatch(e, "Error decompressing byte array.");
            return null;
        }
        catch (IOException e) {
            RadixExcept.logFatalCatch(e, "Error decompressing byte array.");
            return null;
        }
    }

    public static void writeByteArray(ByteBuf buffer, byte[] byteArray) {
        byte[] compressedArray = ByteBufIO.compress(byteArray);
        buffer.writeInt(compressedArray.length);
        buffer.writeBytes(compressedArray);
    }

    public static byte[] readByteArray(ByteBuf buffer) {
        int arraySize = buffer.readInt();
        return ByteBufIO.decompress(buffer.readBytes(arraySize).array());
    }
}

