/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.integration.waila;

import cpw.mods.fml.common.Optional;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.milk.common.tileentity.TileEntityButterChurn;
import growthcraft.milk.common.tileentity.TileEntityCheeseBlock;
import growthcraft.milk.common.tileentity.TileEntityCheesePress;
import growthcraft.milk.common.tileentity.TileEntityHangingCurds;
import growthcraft.milk.util.TagFormatterButterChurn;
import growthcraft.milk.util.TagFormatterCheesePress;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class GrcMilkDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileEntityCheeseBlock) {
            return ((TileEntityCheeseBlock)te).asItemStack();
        }
        if (te instanceof TileEntityHangingCurds) {
            return ((TileEntityHangingCurds)te).asItemStack();
        }
        return accessor.getStack();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String result;
        TileEntity te = accessor.getTileEntity();
        NBTTagCompound nbt = accessor.getNBTData();
        if (te instanceof TileEntityButterChurn) {
            TagFormatterButterChurn.INSTANCE.format(tooltip, nbt);
        }
        if (te instanceof TileEntityCheesePress) {
            TagFormatterCheesePress.INSTANCE.format(tooltip, nbt);
        }
        if (te instanceof TileEntityCheeseBlock) {
            if (nbt.func_74767_n("is_aged")) {
                tooltip.add(EnumChatFormatting.GRAY + GrcI18n.translate("grcmilk.cheese.slices.prefix") + EnumChatFormatting.WHITE + GrcI18n.translate("grcmilk.cheese.slices.value.format", nbt.func_74762_e("slices"), nbt.func_74762_e("slices_max")));
            } else {
                float ageProgress = nbt.func_74760_g("age_progress");
                result = EnumChatFormatting.GRAY + GrcI18n.translate("grcmilk.cheese.aging.prefix") + EnumChatFormatting.WHITE + GrcI18n.translate("grcmilk.cheese.aging.progress.format", (int)(ageProgress * 100.0f));
                tooltip.add(result);
            }
        }
        if (te instanceof TileEntityHangingCurds) {
            boolean dried;
            float progress = nbt.func_74760_g("progress");
            if (progress < 1.0f) {
                result = EnumChatFormatting.GRAY + GrcI18n.translate("grcmilk.hanging_curds.drying.prefix") + EnumChatFormatting.WHITE + GrcI18n.translate("grcmilk.hanging_curds.drying.progress.format", (int)(progress * 100.0f));
                tooltip.add(result);
            }
            if (nbt.func_74764_b("dried") && (dried = nbt.func_74767_n("dried"))) {
                tooltip.add(GrcI18n.translate("grcmilk.hanging_curds.dried"));
            }
        }
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    private void getButterChurnData(TileEntityButterChurn te, NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)NBTHelper.writeItemStackToNBT(te.func_70301_a(0), new NBTTagCompound()));
    }

    private void getCheesePressData(TileEntityCheesePress te, NBTTagCompound nbt) {
        nbt.func_74757_a("pressed", te.isPressed());
        nbt.func_74782_a("item", (NBTBase)NBTHelper.writeItemStackToNBT(te.func_70301_a(0), new NBTTagCompound()));
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileEntityButterChurn) {
            this.getButterChurnData((TileEntityButterChurn)te, tag);
        }
        if (te instanceof TileEntityCheesePress) {
            this.getCheesePressData((TileEntityCheesePress)te, tag);
        }
        if (te instanceof TileEntityCheeseBlock) {
            TileEntityCheeseBlock cheeseBlock = (TileEntityCheeseBlock)te;
            tag.func_74757_a("is_aged", cheeseBlock.getCheese().isAged());
            tag.func_74776_a("age_progress", cheeseBlock.getCheese().getAgeProgress());
            tag.func_74768_a("slices", cheeseBlock.getCheese().getSlices());
            tag.func_74768_a("slices_max", cheeseBlock.getCheese().getSlicesMax());
        }
        if (te instanceof TileEntityHangingCurds) {
            TileEntityHangingCurds hangingCurds = (TileEntityHangingCurds)te;
            tag.func_74776_a("progress", hangingCurds.getProgress());
            tag.func_74757_a("dried", hangingCurds.isDried());
        }
        return tag;
    }
}

