/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import com.google.common.base.Joiner;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.core.GrowthCraftCore;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class UnitFormatter {
    public static final String fractionSeparator = EnumChatFormatting.GRAY + " / ";

    private UnitFormatter() {
    }

    public static String fraction(String ... args) {
        return Joiner.on((String)fractionSeparator).join((Object[])args);
    }

    public static String fractionNum(int a, int b) {
        return UnitFormatter.fraction("" + EnumChatFormatting.WHITE + a, "" + EnumChatFormatting.WHITE + b);
    }

    public static String fluidBucketName(Fluid fluid) {
        return GrcI18n.translate("item.bucket." + fluid.getUnlocalizedName() + ".name");
    }

    @Nullable
    public static String fluidModifier(Fluid fluid) {
        String modifierString;
        String modifierSrc = fluid.getUnlocalizedName() + ".modifier";
        if (modifierSrc.equals(modifierString = GrcI18n.translate(modifierSrc))) {
            Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(fluid);
            if (tags == null || tags.size() == 0) {
                return null;
            }
            String str = "";
            for (FluidTag tag : tags) {
                if (GrowthCraftCore.getConfig().hidePoisonedBooze && tag == BoozeTag.POISONED) continue;
                str = str + (str.length() == 0 ? "" : ", ") + tag.getLocalizedName();
            }
            modifierString = str;
        }
        return EnumChatFormatting.GREEN + modifierString;
    }

    @Nullable
    public static String fluidModifier(FluidStack fluid) {
        return UnitFormatter.fluidModifier(fluid.getFluid());
    }

    @Nullable
    public static String fluidName(FluidStack fluidStack) {
        if (fluidStack != null) {
            Fluid fluid = fluidStack.getFluid();
            String modifier = UnitFormatter.fluidModifier(fluid);
            if (modifier != null) {
                return GrcI18n.translate("grc.format.booze.name", EnumChatFormatting.WHITE + fluidStack.getLocalizedName(), modifier);
            }
            return GrcI18n.translate("grc.format.fluid.name", EnumChatFormatting.WHITE + fluidStack.getLocalizedName());
        }
        return null;
    }

    @Nullable
    public static String fluidNameForContainer(FluidStack fluidStack) {
        String name = UnitFormatter.fluidName(fluidStack);
        if (name != null) {
            return name;
        }
        return UnitFormatter.invalidFluid();
    }

    public static String noItem() {
        return EnumChatFormatting.GRAY + GrcI18n.translate("grc.format.itemslot.empty");
    }

    public static String invalidItem() {
        return EnumChatFormatting.RED + GrcI18n.translate("grc.format.itemslot.invalid");
    }

    public static String noFluid() {
        return EnumChatFormatting.GRAY + GrcI18n.translate("grc.format.tank.empty");
    }

    public static String invalidFluid() {
        return EnumChatFormatting.RED + GrcI18n.translate("grc.format.invalid_fluid");
    }

    public static String booleanAsState(boolean b) {
        return GrcI18n.translate("grc.format.state." + b);
    }

    public static String booleanAsValue(boolean b) {
        return GrcI18n.translate("grc.format.value." + b);
    }
}

