/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class Utils {
    public static final int DRAIN_CAP = 1000;

    private Utils() {
    }

    public static void debug(String msg) {
        boolean flag = true;
        System.out.println(msg);
    }

    public static boolean isIDInList(int id, String list) {
        String[] itemArray = list.split(";");
        for (int i = 0; i < itemArray.length; ++i) {
            String[] values = itemArray[i].split(",");
            int tempID = Utils.parseInt(values[0], Integer.MAX_VALUE);
            if (tempID == Integer.MAX_VALUE || tempID != id) continue;
            return true;
        }
        return false;
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static final boolean isIntegerInRange(int i, int floor, int ceiling) {
        return i >= floor && i <= ceiling;
    }

    public static void spawnExp(int amount, float exp, EntityPlayer player) {
        int j;
        if (exp == 0.0f) {
            amount = 0;
        } else if (exp < 1.0f) {
            j = MathHelper.func_76141_d((float)((float)amount * exp));
            if (j < MathHelper.func_76123_f((float)((float)amount * exp)) && (float)Math.random() < (float)amount * exp - (float)j) {
                ++j;
            }
            amount = j;
        }
        while (amount > 0) {
            j = EntityXPOrb.func_70527_a((int)amount);
            amount -= j;
            player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, j));
        }
    }

    public static boolean playerFillTank(World world, int x, int y, int z, IFluidHandler tank, ItemStack held, EntityPlayer player) {
        if (held == null) {
            return false;
        }
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        if (held.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)held.func_77973_b();
            FluidStack willDrain = container.drain(held, 1000, false);
            if (willDrain == null || willDrain.amount <= 0) {
                return false;
            }
            int used = tank.fill(direction, willDrain, false);
            if (used <= 0) {
                return false;
            }
            if (!world.field_72995_K) {
                tank.fill(direction, willDrain, true);
                container.drain(held, used, true);
            }
        } else {
            FluidStack heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)held);
            if (heldContents == null) {
                return false;
            }
            int used = tank.fill(direction, heldContents, false);
            if (used <= 0) {
                return false;
            }
            if (!world.field_72995_K) {
                tank.fill(direction, heldContents, true);
                ItemStack containerItem = FluidContainerRegistry.drainFluidContainer((ItemStack)held);
                if (!player.field_71071_by.func_70441_a(containerItem)) {
                    if (containerItem != null) {
                        world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, containerItem));
                    }
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                if (!player.field_71075_bZ.field_75098_d && --held.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
        }
        return true;
    }

    public static FluidStack playerDrainTank(World world, int x, int y, int z, IFluidHandler tank, ItemStack held, EntityPlayer player, boolean expbool, int amount, float exp) {
        if (held == null) {
            return null;
        }
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        FluidStack available = tank.drain(direction, 1000, false);
        if (available == null) {
            return null;
        }
        if (held.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)held.func_77973_b();
            int filled = container.fill(held, available, false);
            if (filled <= 0) {
                return null;
            }
            tank.drain(direction, filled, true);
            container.fill(held, available, true);
        } else {
            FluidStack heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)held);
            ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)held);
            heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
            if (heldContents == null) {
                return null;
            }
            if (!player.field_71071_by.func_70441_a(filled)) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, filled));
            } else if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
            if (!player.field_71075_bZ.field_75098_d && --held.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (expbool) {
                Utils.spawnExp(amount * heldContents.amount / tank.getTankInfo((ForgeDirection)direction)[0].capacity, exp, player);
            }
            tank.drain(direction, heldContents.amount, true);
        }
        return available;
    }

    public static FluidStack playerDrainTank(World world, int x, int y, int z, IFluidHandler tank, ItemStack held, EntityPlayer player) {
        return Utils.playerDrainTank(world, x, y, z, tank, held, player, false, 0, 0.0f);
    }
}

