/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.util;

import growthcraft.api.cellar.brewing.user.UserBrewingRecipesConfig;
import growthcraft.api.cellar.culturing.user.UserCultureRecipesConfig;
import growthcraft.api.cellar.fermenting.user.UserFermentingRecipesConfig;
import growthcraft.api.cellar.heatsource.user.UserHeatSourcesConfig;
import growthcraft.api.cellar.pressing.user.UserPressingRecipesConfig;
import growthcraft.api.cellar.yeast.user.UserYeastEntriesConfig;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.IModule;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.core.common.GrcModuleBase;
import javax.annotation.Nonnull;

public class GrcCellarUserApis
extends GrcModuleBase {
    private UserBrewingRecipesConfig userBrewingRecipes;
    private UserCultureRecipesConfig userCultureRecipes;
    private UserFermentingRecipesConfig userFermentingRecipes;
    private UserHeatSourcesConfig userHeatSources;
    private UserPressingRecipesConfig userPressingRecipes;
    private UserYeastEntriesConfig userYeastEntries;
    private ModuleContainer modules = new ModuleContainer();

    public GrcCellarUserApis() {
        this.userBrewingRecipes = new UserBrewingRecipesConfig();
        this.userCultureRecipes = new UserCultureRecipesConfig();
        this.userFermentingRecipes = new UserFermentingRecipesConfig();
        this.userHeatSources = new UserHeatSourcesConfig();
        this.userPressingRecipes = new UserPressingRecipesConfig();
        this.userYeastEntries = new UserYeastEntriesConfig();
        this.modules.add(this.userBrewingRecipes);
        this.modules.add(this.userCultureRecipes);
        this.modules.add(this.userFermentingRecipes);
        this.modules.add(this.userHeatSources);
        this.modules.add(this.userPressingRecipes);
        this.modules.add(this.userYeastEntries);
    }

    @Override
    public void setLogger(@Nonnull ILogger log) {
        super.setLogger(log);
        this.modules.setLogger(log);
    }

    public UserBrewingRecipesConfig getUserBrewingRecipes() {
        return this.userBrewingRecipes;
    }

    public UserCultureRecipesConfig getUserCultureRecipes() {
        return this.userCultureRecipes;
    }

    public UserFermentingRecipesConfig getUserFermentingRecipes() {
        return this.userFermentingRecipes;
    }

    public UserHeatSourcesConfig getUserHeatSources() {
        return this.userHeatSources;
    }

    public UserPressingRecipesConfig getUserPressingRecipes() {
        return this.userPressingRecipes;
    }

    public UserYeastEntriesConfig getUserYeastEntries() {
        return this.userYeastEntries;
    }

    @Override
    public void preInit() {
        this.modules.preInit();
    }

    @Override
    public void register() {
        this.modules.register();
    }

    @Override
    public void init() {
        this.modules.init();
    }

    @Override
    public void postInit() {
        this.modules.postInit();
    }

    public void loadConfigs() {
        for (IModule module : this.modules) {
            if (!(module instanceof AbstractUserJSONConfig)) continue;
            ((AbstractUserJSONConfig)module).loadUserConfig();
        }
    }
}

