/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.util;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.cellar.booze.BoozeEffect;
import growthcraft.api.cellar.booze.BoozeEntry;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.booze.IBoozeRegistry;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.IFluidDictionary;
import growthcraft.cellar.common.block.BlockFluidBooze;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.ItemBlockFluidBooze;
import growthcraft.cellar.common.item.ItemBucketBooze;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.core.eventhandler.EventHandlerBucketFill;
import growthcraft.core.integration.NEI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BoozeRegistryHelper {
    private BoozeRegistryHelper() {
    }

    public static void initializeBoozeFluids(String basename, Booze[] boozes) {
        for (int i = 0; i < boozes.length; ++i) {
            boozes[i] = new Booze(basename + i);
            FluidRegistry.registerFluid((Fluid)boozes[i]);
            CellarRegistry.instance().booze().registerBooze(boozes[i]);
        }
    }

    public static void initializeBooze(Fluid[] boozes, BlockBoozeDefinition[] fluidBlocks, ItemBucketBoozeDefinition[] buckets) {
        for (int i = 0; i < boozes.length; ++i) {
            BlockFluidBooze boozeBlock = new BlockFluidBooze(boozes[i]);
            fluidBlocks[i] = new BlockBoozeDefinition(boozeBlock);
            buckets[i] = new ItemBucketBoozeDefinition(new ItemBucketBooze((Block)boozeBlock, boozes[i]));
        }
    }

    public static void setBoozeFoodStats(Fluid booze, int heal, float saturation) {
        BoozeEntry entry = CellarRegistry.instance().booze().getBoozeEntry(booze);
        if (entry != null) {
            entry.setFoodStats(heal, saturation);
        }
    }

    public static void setBoozeFoodStats(Fluid[] boozes, int heal, float saturation) {
        for (Fluid booze : boozes) {
            BoozeRegistryHelper.setBoozeFoodStats(booze, heal, saturation);
        }
    }

    public static void registerBooze(Fluid[] boozes, BlockBoozeDefinition[] fluidBlocks, ItemBucketBoozeDefinition[] buckets, ItemDefinition bottle, String basename, @Nullable ItemDefinition oldBucket) {
        for (int i = 0; i < boozes.length; ++i) {
            buckets[i].register(basename + "Bucket." + i);
            fluidBlocks[i].register(basename + "Fluid." + i, ItemBlockFluidBooze.class);
            EventHandlerBucketFill.instance().register((Block)fluidBlocks[i].getBlock(), (Item)buckets[i].getItem());
            FluidStack boozeStack = new FluidStack(boozes[i], 1000);
            FluidContainerRegistry.registerFluidContainer((FluidStack)boozeStack, (ItemStack)buckets[i].asStack(), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
            FluidStack fluidStack = new FluidStack(boozes[i], GrowthCraftCore.getConfig().bottleCapacity);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bottle.asStack(1, i), (ItemStack)GrowthCraftCore.EMPTY_BOTTLE);
            GameRegistry.addShapelessRecipe((ItemStack)bottle.asStack(3, i), (Object[])new Object[]{buckets[i].getItem(), Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo});
            if (oldBucket == null) continue;
            GameRegistry.addShapelessRecipe((ItemStack)buckets[i].asStack(), (Object[])new Object[]{oldBucket.asStack(1, i)});
            NEI.hideItem(oldBucket.asStack(1, i));
        }
    }

    public static List<BoozeEffect> getBoozeEffects(Fluid[] boozes) {
        IBoozeRegistry reg = CellarRegistry.instance().booze();
        IFluidDictionary dict = CoreRegistry.instance().fluidDictionary();
        ArrayList<BoozeEffect> effects = new ArrayList<BoozeEffect>();
        for (int i = 0; i < boozes.length; ++i) {
            if (!dict.hasFluidTags(boozes[i], BoozeTag.FERMENTED)) continue;
            effects.add(reg.getEffect(boozes[i]));
        }
        return effects;
    }
}

