/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.client.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import growthcraft.bamboo.GrowthCraftBamboo;
import growthcraft.bamboo.common.block.BlockBambooStalk;
import growthcraft.core.util.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderBamboo
implements ISimpleBlockRenderingHandler {
    public static int id = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        IIcon icon = BlockBambooStalk.tex[0];
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        RenderUtils.drawFace(RenderUtils.Face.YPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawFace(RenderUtils.Face.YNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        float d = 0.75f;
        icon = BlockBambooStalk.tex[2];
        renderer.func_147782_a(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
        RenderUtils.drawFace(RenderUtils.Face.ZNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawFace(RenderUtils.Face.ZPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawFace(RenderUtils.Face.XNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawFace(RenderUtils.Face.XPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (modelId == id) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            float f = 1.0f;
            int meta = world.func_72805_g(x, y, z);
            int color = 0xFFFFFF;
            if (meta == 0) {
                color = block.func_149720_d(world, x, y, z);
            }
            float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(color & 0xFF) / 255.0f;
            if (EntityRenderer.field_78517_a) {
                float f5 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
                float f4 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
                float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
                f1 = f5;
                f2 = f4;
                f3 = f6;
            }
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            IIcon icon = BlockBambooStalk.tex[0];
            renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
            renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
            float d = 0.75f;
            tessellator.func_78386_a(1.0f * f1 * 0.75f, 1.0f * f2 * 0.75f, 1.0f * f3 * 0.75f);
            renderer.func_147782_a(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
            icon = BlockBambooStalk.tex[2];
            renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
            renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
            renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
            renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            if (meta != 0) {
                if (this.canFence(world, x, y, z - 1)) {
                    this.renderFence(renderer, world, block, x, y, z, RenderUtils.Face.ZNEG);
                } else if (this.canWall(world, x, y, z - 1)) {
                    this.renderWall(renderer, world, block, x, y, z, RenderUtils.Face.ZNEG);
                } else if (this.canDoor(world, x, y, z - 1)) {
                    this.renderDoor(renderer, world, block, x, y, z, RenderUtils.Face.ZNEG);
                }
                if (this.canFence(world, x, y, z + 1)) {
                    this.renderFence(renderer, world, block, x, y, z, RenderUtils.Face.ZPOS);
                } else if (this.canWall(world, x, y, z + 1)) {
                    this.renderWall(renderer, world, block, x, y, z, RenderUtils.Face.ZPOS);
                } else if (this.canDoor(world, x, y, z + 1)) {
                    this.renderDoor(renderer, world, block, x, y, z, RenderUtils.Face.ZPOS);
                }
                if (this.canFence(world, x - 1, y, z)) {
                    this.renderFence(renderer, world, block, x, y, z, RenderUtils.Face.XNEG);
                } else if (this.canWall(world, x - 1, y, z)) {
                    this.renderWall(renderer, world, block, x, y, z, RenderUtils.Face.XNEG);
                } else if (this.canDoor(world, x - 1, y, z)) {
                    this.renderDoor(renderer, world, block, x, y, z, RenderUtils.Face.XNEG);
                }
                if (this.canFence(world, x + 1, y, z)) {
                    this.renderFence(renderer, world, block, x, y, z, RenderUtils.Face.XPOS);
                } else if (this.canWall(world, x + 1, y, z)) {
                    this.renderWall(renderer, world, block, x, y, z, RenderUtils.Face.XPOS);
                } else if (this.canDoor(world, x + 1, y, z)) {
                    this.renderDoor(renderer, world, block, x, y, z, RenderUtils.Face.XPOS);
                }
            }
            renderer.func_147771_a();
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return true;
    }

    private boolean canFence(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooFence.getBlock() || world.func_147439_a(x, y, z) == Blocks.field_150396_be || world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooFenceGate.getBlock();
    }

    private boolean canWall(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooWall.getBlock();
    }

    private boolean canDoor(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockDoor;
    }

    private void renderFence(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, RenderUtils.Face m) {
        renderer.func_147757_a(BlockBambooStalk.tex[3]);
        double x1 = x;
        double x2 = (double)x + 1.0;
        double z1 = z;
        double z2 = (double)z + 1.0;
        double y1 = 0.75;
        double y2 = 0.9375;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.4375;
            x2 = 0.5625;
            z1 = 0.0;
            z2 = 0.25;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.4375;
            x2 = 0.5625;
            z1 = 0.75;
            z2 = 1.0;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.4375;
            z2 = 0.5625;
            x1 = 0.0;
            x2 = 0.25;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.4375;
            z2 = 0.5625;
            x1 = 0.75;
            x2 = 1.0;
        }
        renderer.func_147782_a(x1, y1, z1, x2, y2, z2);
        renderer.func_147784_q(block, x, y, z);
        y1 = 0.375;
        y2 = 0.5625;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.4375;
            x2 = 0.5625;
            z1 = 0.0;
            z2 = 0.25;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.4375;
            x2 = 0.5625;
            z1 = 0.75;
            z2 = 1.0;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.4375;
            z2 = 0.5625;
            x1 = 0.0;
            x2 = 0.25;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.4375;
            z2 = 0.5625;
            x1 = 0.75;
            x2 = 1.0;
        }
        renderer.func_147782_a(x1, y1, z1, x2, y2, z2);
        renderer.func_147784_q(block, x, y, z);
        renderer.func_147771_a();
    }

    private void renderWall(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, RenderUtils.Face m) {
        renderer.func_147757_a(BlockBambooStalk.tex[4]);
        double x1 = x;
        double x2 = (double)x + 1.0;
        double z1 = z;
        double z2 = (double)z + 1.0;
        double y1 = 0.0;
        double y2 = 1.0;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.375;
            x2 = 0.625;
            z1 = 0.0;
            z2 = 0.25;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.375;
            x2 = 0.625;
            z1 = 0.75;
            z2 = 1.0;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.375;
            z2 = 0.625;
            x1 = 0.0;
            x2 = 0.25;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.375;
            z2 = 0.625;
            x1 = 0.75;
            x2 = 1.0;
        }
        renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
        renderer.func_147784_q(block, x, y, z);
        renderer.func_147771_a();
    }

    private void renderDoor(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, RenderUtils.Face m) {
        renderer.func_147757_a(BlockBambooStalk.tex[4]);
        double x1 = x;
        double x2 = (double)x + 1.0;
        double z1 = z;
        double z2 = (double)z + 1.0;
        double y1 = 0.0;
        double y2 = 1.0;
        if (m == RenderUtils.Face.ZNEG) {
            int tm;
            int tm0 = world.func_72805_g(x, y, z - 1);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x, y - 1, z - 1);
            }
            if ((tm = tm0 & 3) == 0) {
                x1 = 0.0;
                x2 = 0.375;
                z1 = 0.0;
                z2 = 0.25;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
            if (tm == 2) {
                x1 = 0.625;
                x2 = 1.0;
                z1 = 0.0;
                z2 = 0.25;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
        } else if (m == RenderUtils.Face.ZPOS) {
            int tm;
            int tm0 = world.func_72805_g(x, y, z + 1);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x, y - 1, z + 1);
            }
            if ((tm = tm0 & 3) == 0) {
                x1 = 0.0;
                x2 = 0.375;
                z1 = 0.75;
                z2 = 1.0;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
            if (tm == 2) {
                x1 = 0.625;
                x2 = 1.0;
                z1 = 0.75;
                z2 = 1.0;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
        } else if (m == RenderUtils.Face.XNEG) {
            int tm;
            int tm0 = world.func_72805_g(x - 1, y, z);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x - 1, y - 1, z);
            }
            if ((tm = tm0 & 3) == 1) {
                x1 = 0.0;
                x2 = 0.25;
                z1 = 0.0;
                z2 = 0.375;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
            if (tm == 3) {
                x1 = 0.0;
                x2 = 0.25;
                z1 = 0.625;
                z2 = 1.0;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
        } else if (m == RenderUtils.Face.XPOS) {
            int tm;
            int tm0 = world.func_72805_g(x + 1, y, z);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x + 1, y - 1, z);
            }
            if ((tm = tm0 & 3) == 1) {
                x1 = 0.75;
                x2 = 1.0;
                z1 = 0.0;
                z2 = 0.375;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
            if (tm == 3) {
                x1 = 0.75;
                x2 = 1.0;
                z1 = 0.625;
                z2 = 1.0;
                renderer.func_147782_a(x1, 0.0, z1, x2, 1.0, z2);
                renderer.func_147784_q(block, x, y, z);
            }
        }
        renderer.func_147771_a();
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return id;
    }
}

