/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.churn.user;

import growthcraft.api.core.schema.FluidStackSchema;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.api.milk.churn.IChurnRecipe;
import growthcraft.api.milk.churn.user.UserChurnRecipe;
import growthcraft.api.milk.churn.user.UserChurnRecipes;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UserChurnRecipesConfig
extends AbstractUserJSONConfig {
    private final UserChurnRecipes defaultRecipes = new UserChurnRecipes();
    private UserChurnRecipes recipes;

    public void addDefault(UserChurnRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(FluidStack inp, FluidStack out, ItemStack stack, int churns) {
        this.addDefault(new UserChurnRecipe(new FluidStackSchema(inp), new FluidStackSchema(out), new ItemKeySchema(stack), churns));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserChurnRecipes)this.gson.fromJson((Reader)reader, UserChurnRecipes.class);
    }

    private void addChurnRecipe(UserChurnRecipe recipe) {
        if (recipe == null) {
            this.logger.error("Invalid recipe", new Object[0]);
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            this.logger.error("Invalid input_fluid {%s}", recipe);
            return;
        }
        for (IChurnRecipe churnRecipe : recipe.toChurnRecipes()) {
            this.logger.debug("Adding user churn recipe {%s}", churnRecipe);
            MilkRegistry.instance().churn().addRecipe(churnRecipe);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                this.logger.debug("Adding %d user brewing recipes.", this.recipes.data.size());
                for (UserChurnRecipe recipe : this.recipes.data) {
                    this.addChurnRecipe(recipe);
                }
            } else {
                this.logger.error("Recipes data is invalid!", new Object[0]);
            }
        }
    }
}

