/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.cheesevat;

import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.item.ItemTest;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.milk.cheesevat.CheeseVatRecipe;
import growthcraft.api.milk.cheesevat.ICheeseVatRecipe;
import growthcraft.api.milk.cheesevat.ICheeseVatRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CheeseVatRegistry
implements ICheeseVatRegistry {
    private ILogger logger = NullLogger.INSTANCE;
    private List<ICheeseVatRecipe> recipes = new ArrayList<ICheeseVatRecipe>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(ICheeseVatRecipe recipe) {
        this.recipes.add(recipe);
        this.logger.debug("Added Cheese Vat recipe {%s}", recipe);
    }

    @Override
    public void addRecipe(@Nonnull List<FluidStack> outputFluids, @Nonnull List<ItemStack> outputItems, @Nonnull List<IMultiFluidStacks> inputFluids, @Nonnull List<IMultiItemStacks> inputItems) {
        CheeseVatRecipe recipe = new CheeseVatRecipe(outputFluids, outputItems, inputFluids, inputItems);
        this.addRecipe(recipe);
    }

    @Override
    public boolean isFluidIngredient(@Nullable Fluid fluid) {
        if (!FluidTest.isValid(fluid)) {
            return false;
        }
        for (ICheeseVatRecipe recipe : this.recipes) {
            if (!recipe.isFluidIngredient(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFluidIngredient(@Nullable FluidStack fluid) {
        if (!FluidTest.isValid(fluid)) {
            return false;
        }
        for (ICheeseVatRecipe recipe : this.recipes) {
            if (!recipe.isFluidIngredient(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemIngredient(@Nullable ItemStack item) {
        if (!ItemTest.isValid(item)) {
            return false;
        }
        for (ICheeseVatRecipe recipe : this.recipes) {
            if (!recipe.isItemIngredient(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ICheeseVatRecipe findRecipe(@Nonnull List<FluidStack> fluids, @Nonnull List<ItemStack> stacks) {
        for (ICheeseVatRecipe recipe : this.recipes) {
            if (!recipe.isMatchingRecipe(fluids, stacks)) continue;
            return recipe;
        }
        return null;
    }
}

